/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.FieldTypeProducer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Poster;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.plugin.client.api.DeleteColumns;
import org.drools.workbench.services.verifier.plugin.client.api.MakeRule;
import org.drools.workbench.services.verifier.plugin.client.api.NewColumn;
import org.drools.workbench.services.verifier.plugin.client.api.RemoveRule;
import org.drools.workbench.services.verifier.plugin.client.api.Update;
import org.drools.workbench.services.verifier.plugin.client.builders.ModelMetaDataEnhancer;
import org.kie.soup.commons.validation.PortablePreconditions;

public class DTableUpdateManagerImpl
implements DTableUpdateManager {
    private Poster poster;
    private FieldTypeProducer fieldTypeProducer;

    public DTableUpdateManagerImpl(Poster poster, FieldTypeProducer fieldTypeProducer) {
        this.poster = (Poster)PortablePreconditions.checkNotNull((String)"poster", (Object)poster);
        this.fieldTypeProducer = (FieldTypeProducer)PortablePreconditions.checkNotNull((String)"fieldTypeProducer", (Object)fieldTypeProducer);
    }

    public void update(GuidedDecisionTable52 model, List<Coordinate> coordinates) {
        this.poster.post(new Update(model, coordinates));
    }

    public void newColumn(GuidedDecisionTable52 model, int columnIndex) {
        this.poster.post(new NewColumn(model, new ModelMetaDataEnhancer(model).getHeaderMetaData(), this.fieldTypeProducer.getFactTypes(), columnIndex));
    }

    public void deleteColumns(int firstColumnIndex, int numberOfColumns) {
        this.poster.post(new DeleteColumns(firstColumnIndex, numberOfColumns));
    }

    public void removeRule(Integer rowDeleted) {
        this.poster.post(new RemoveRule(rowDeleted));
    }

    public void makeRule(GuidedDecisionTable52 model, int index) {
        this.poster.post(new MakeRule(model, new ModelMetaDataEnhancer(model).getHeaderMetaData(), this.fieldTypeProducer.getFactTypes(), index));
    }
}

