/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller;

import com.google.gwt.event.shared.EventBus;
import java.util.logging.Logger;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnDeleted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnInserted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AnalyzerController;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.Events;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.ValidateEvent;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.uberfire.client.mvp.PlaceManager;

public class AnalyzerControllerImpl
implements AnalyzerController,
ValidateEvent.Handler,
DeleteRowEvent.Handler,
AfterColumnDeleted.Handler,
UpdateColumnDataEvent.Handler,
AppendRowEvent.Handler,
InsertRowEvent.Handler,
AfterColumnInserted.Handler {
    private static final Logger LOGGER = Logger.getLogger("DTable Analyzer");
    private final DecisionTableAnalyzer decisionTableAnalyzer;
    private final Events events;
    private PlaceManager placeManager;

    public AnalyzerControllerImpl(DecisionTableAnalyzer decisionTableAnalyzer, PlaceManager placeManager, EventBus eventBus) {
        this.decisionTableAnalyzer = (DecisionTableAnalyzer)PortablePreconditions.checkNotNull((String)"decisionTableAnalyzer", (Object)decisionTableAnalyzer);
        this.placeManager = (PlaceManager)PortablePreconditions.checkNotNull((String)"placeManager", (Object)placeManager);
        this.events = new Events((EventBus)PortablePreconditions.checkNotNull((String)"eventBus", (Object)eventBus), this);
    }

    @Override
    public void initialiseAnalysis() {
        LOGGER.info("Initializing analysis.");
        this.events.setup();
        this.decisionTableAnalyzer.activate();
    }

    @Override
    public void terminateAnalysis() {
        LOGGER.info("Terminating analysis.");
        this.events.teardown();
        this.decisionTableAnalyzer.terminate();
        this.placeManager.closePlace("org.drools.workbench.AnalysisReportScreen");
    }

    @Override
    public void onValidate(ValidateEvent event) {
        this.decisionTableAnalyzer.analyze(event.getUpdates());
    }

    @Override
    public void onAfterDeletedColumn(AfterColumnDeleted event) {
        this.decisionTableAnalyzer.deleteColumns(event.getFirstColumnIndex(), event.getNumberOfColumns());
    }

    @Override
    public void onAfterColumnInserted(AfterColumnInserted event) {
        this.decisionTableAnalyzer.insertColumn(event.getColumn());
    }

    public void onAppendRow(AppendRowEvent event) {
        this.decisionTableAnalyzer.appendRow();
    }

    public void onDeleteRow(DeleteRowEvent event) {
        this.decisionTableAnalyzer.deleteRow(event.getIndex());
    }

    public void onInsertRow(InsertRowEvent event) {
        this.decisionTableAnalyzer.insertRow(event.getIndex());
    }

    public void onUpdateColumnData(UpdateColumnDataEvent event) {
        this.decisionTableAnalyzer.updateColumns(event.getColumnData().size());
    }
}

