/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreenView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssueSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuesSet;
import org.drools.workbench.services.verifier.api.client.Status;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.workbench.AnalysisReportScreen", preferredWidth=360)
public class AnalysisReportScreen {
    public static final String IDENTIFIER = "org.drools.workbench.AnalysisReportScreen";
    private static final Logger LOGGER = Logger.getLogger("DTable Analyzer");
    private AnalysisReportScreenView view;
    private PlaceManager placeManager;
    private Event<IssueSelectedEvent> issueSelectedEvent;
    private final ListDataProvider<Issue> dataProvider = new ListDataProvider();
    private PlaceRequest currentPlace;

    public AnalysisReportScreen() {
    }

    @Inject
    public AnalysisReportScreen(AnalysisReportScreenView view, PlaceManager placeManager, Event<IssueSelectedEvent> issueSelectedEvent) {
        this.view = view;
        this.placeManager = placeManager;
        this.issueSelectedEvent = issueSelectedEvent;
        view.setPresenter(this);
        view.setUpDataProvider(this.dataProvider);
    }

    @OnClose
    public void onClose() {
        this.dataProvider.flush();
        this.view.clearIssue();
    }

    public void showReport(AnalysisReport report) {
        LOGGER.finest("Received report for: " + report.getPlace().getPath());
        if (!report.getPlace().equals(this.currentPlace)) {
            return;
        }
        this.view.showStatusComplete();
        this.dataProvider.setList(this.getIssues(report));
        if (this.dataProvider.getList().isEmpty()) {
            this.fireIssueSelectedEvent(Issue.EMPTY);
            this.view.clearIssue();
        } else {
            Issue issue = (Issue)this.dataProvider.getList().get(0);
            this.onSelect(issue);
        }
        if (!report.getAnalysisData().isEmpty()) {
            LOGGER.finest("goto org.drools.workbench.AnalysisReportScreen");
            this.placeManager.goTo(IDENTIFIER);
            LOGGER.finest("went org.drools.workbench.AnalysisReportScreen");
        } else {
            LOGGER.finest("close org.drools.workbench.AnalysisReportScreen");
            this.placeManager.closePlace(IDENTIFIER);
            LOGGER.finest("closed org.drools.workbench.AnalysisReportScreen");
        }
    }

    public void setCurrentPlace(PlaceRequest place) {
        LOGGER.info("Activating place: " + place.getPath());
        this.currentPlace = place;
    }

    private ArrayList<Issue> getIssues(AnalysisReport report) {
        return new ArrayList<Issue>(new IssuesSet(report.getAnalysisData()));
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.Analysis();
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void onSelect(Issue issue) {
        this.view.showIssue(issue);
        this.fireIssueSelectedEvent(issue);
    }

    void fireIssueSelectedEvent(Issue issue) {
        LOGGER.finest("issue.debug: " + issue.getDebugMessage());
        this.issueSelectedEvent.fire((Object)new IssueSelectedEvent(this.currentPlace, issue));
    }

    public void showStatus(Status status) {
        this.view.showStatusTitle(status.getStart(), status.getEnd(), status.getTotalCheckCount());
    }
}

