/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.themes;

import com.ait.lienzo.client.core.shape.Line;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.Shadow;
import com.ait.lienzo.shared.core.types.Color;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import com.ait.lienzo.shared.core.types.TextUnit;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class GuidedDecisionTableTheme
implements GridRendererTheme {
    private static final double GRID_LINE_WIDTH = 1.0;
    private static final String GRID_LINE_COLOUR = Color.rgbToBrowserHexColor((int)160, (int)160, (int)160);
    private static final String GRID_LINK_COLOUR = "#d4eec2";
    private static final String GRID_FONT_COLOUR = "#333333";
    private static final String GRID_FONT_FAMILY = "Open Sans, Helvetica, Arial, sans-serif";
    private static final int GRID_FONT_SIZE = 12;
    private static final String ROW_NUMBER_COLUMN_BACKGROUND_COLOUR = Color.rgbToBrowserHexColor((int)255, (int)255, (int)255);
    private static final String DESCRIPTION_COLUMN_BACKGROUND_COLOUR = Color.rgbToBrowserHexColor((int)255, (int)255, (int)255);
    private static final String METADATA_COLUMN_BACKGROUND_COLOUR = Color.rgbToBrowserHexColor((int)255, (int)255, (int)224);
    private static final String ATTRIBUTE_COLUMN_BACKGROUND_COLOUR = Color.rgbToBrowserHexColor((int)255, (int)255, (int)224);
    private static final String CONDITION_COLUMN_BACKGROUND_COLOUR = Color.rgbToBrowserHexColor((int)239, (int)249, (int)232);
    private static final String ACTION_COLUMN_BACKGROUND_COLOUR = Color.rgbToBrowserHexColor((int)225, (int)243, (int)213);
    private final GuidedDecisionTableUiModel uiModel;
    private final GuidedDecisionTable52 model;

    public GuidedDecisionTableTheme(GuidedDecisionTableUiModel uiModel, GuidedDecisionTable52 model) {
        this.uiModel = (GuidedDecisionTableUiModel)((Object)PortablePreconditions.checkNotNull((String)"uiModel", (Object)((Object)uiModel)));
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public String getName() {
        return "Guided Decision Table Editor";
    }

    public MultiPath getSelector() {
        MultiPath selector = (MultiPath)((MultiPath)((MultiPath)new MultiPath().setStrokeWidth(2.0)).setStrokeColor((IColor)ColorName.GREEN)).setShadow(new Shadow((IColor)ColorName.DARKGREEN, 4, 0.0, 0.0));
        return selector;
    }

    public Rectangle getCellSelectorBorder() {
        Rectangle selector = (Rectangle)((Rectangle)new Rectangle(0.0, 0.0).setStrokeColor((IColor)ColorName.GREEN)).setStrokeWidth(1.0);
        return selector;
    }

    public Rectangle getCellSelectorBackground() {
        Rectangle background = (Rectangle)((Rectangle)new Rectangle(0.0, 0.0).setFillColor((IColor)ColorName.GREEN)).setAlpha(0.25);
        return background;
    }

    public Rectangle getHeaderBackground(GridColumn<?> column) {
        return this.getBaseRectangle(column);
    }

    public Rectangle getHeaderLinkBackground(GridColumn<?> column) {
        Rectangle link = (Rectangle)new Rectangle(0.0, 0.0).setFillColor(GRID_LINK_COLOUR);
        return link;
    }

    public MultiPath getHeaderGridLine() {
        MultiPath headerGrid = (MultiPath)((MultiPath)((MultiPath)new MultiPath().setStrokeColor(GRID_LINE_COLOUR)).setStrokeWidth(1.0)).setListening(false);
        return headerGrid;
    }

    public Text getHeaderText() {
        Text t = ((Text)((Text)new Text("").setFillColor(GRID_FONT_COLOUR)).setFontSize(12.0).setTextUnit(TextUnit.PX).setFontFamily(GRID_FONT_FAMILY).setListening(false)).setTextBaseLine(TextBaseLine.MIDDLE).setTextAlign(TextAlign.CENTER);
        return t;
    }

    public Rectangle getBodyBackground(GridColumn<?> column) {
        return this.getBaseRectangle(column);
    }

    public MultiPath getBodyGridLine() {
        MultiPath bodyGrid = (MultiPath)((MultiPath)((MultiPath)new MultiPath().setStrokeColor(GRID_LINE_COLOUR)).setStrokeWidth(1.0)).setListening(false);
        return bodyGrid;
    }

    public Text getBodyText() {
        Text t = ((Text)((Text)new Text("").setFillColor(GRID_FONT_COLOUR)).setFontSize(12.0).setTextUnit(TextUnit.PX).setFontFamily(GRID_FONT_FAMILY).setListening(false)).setTextBaseLine(TextBaseLine.MIDDLE).setTextAlign(TextAlign.CENTER);
        return t;
    }

    public Rectangle getGridBoundary() {
        Rectangle boundary = (Rectangle)((Rectangle)((Rectangle)new Rectangle(0.0, 0.0).setStrokeColor(GRID_LINE_COLOUR)).setStrokeWidth(1.0)).setListening(false);
        return boundary;
    }

    public Line getGridHeaderBodyDivider() {
        Line divider = (Line)((Line)new Line().setStrokeColor(GRID_LINE_COLOUR)).setStrokeWidth(1.0);
        return divider;
    }

    private Rectangle getBaseRectangle(GridColumn<?> uiColumn) {
        ModelColumnType columnType = this.getModelColumnType(uiColumn);
        return this.getBaseRectangle(columnType);
    }

    public Rectangle getBaseRectangle(ModelColumnType columnType) {
        Rectangle r = new Rectangle(0.0, 0.0);
        switch (columnType) {
            case ROW_NUMBER: {
                r.setFillColor(ROW_NUMBER_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case DESCRIPTION: {
                r.setFillColor(DESCRIPTION_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case METADATA: {
                r.setFillColor(METADATA_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case ATTRIBUTE: {
                r.setFillColor(ATTRIBUTE_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case CONDITION: {
                r.setFillColor(CONDITION_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case ACTION: {
                r.setFillColor(ACTION_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case CAPTION: {
                r.setFillColor(ROW_NUMBER_COLUMN_BACKGROUND_COLOUR);
                break;
            }
            case UNKNOWN: {
                r.setFillColor(ROW_NUMBER_COLUMN_BACKGROUND_COLOUR);
            }
        }
        return r;
    }

    ModelColumnType getModelColumnType(GridColumn<?> uiColumn) {
        int uiColumnIndex = this.uiModel.getColumns().indexOf(uiColumn);
        BaseColumn modelColumn = (BaseColumn)this.model.getExpandedColumns().get(uiColumnIndex);
        if (modelColumn instanceof RowNumberCol52) {
            return ModelColumnType.ROW_NUMBER;
        }
        if (modelColumn instanceof DescriptionCol52) {
            return ModelColumnType.DESCRIPTION;
        }
        if (modelColumn instanceof MetadataCol52) {
            return ModelColumnType.METADATA;
        }
        if (modelColumn instanceof AttributeCol52) {
            return ModelColumnType.ATTRIBUTE;
        }
        if (modelColumn instanceof ConditionCol52) {
            return ModelColumnType.CONDITION;
        }
        if (modelColumn instanceof ActionCol52) {
            return ModelColumnType.ACTION;
        }
        return ModelColumnType.UNKNOWN;
    }

    public static enum ModelColumnType {
        ROW_NUMBER,
        DESCRIPTION,
        METADATA,
        ATTRIBUTE,
        CONDITION,
        ACTION,
        CAPTION,
        UNKNOWN;

    }
}

