/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasFieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.HasList;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.BindingTextBox;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class FieldPage<T extends HasFieldPage & DecisionTableColumnPlugin>
extends BaseDecisionTableColumnPage<T> {
    private View view;

    @Inject
    public FieldPage(View view, TranslationService translationService) {
        super(translationService);
        this.view = view;
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public String getTitle() {
        return this.translate("FieldPage.Field", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isFieldBindingValid = ((HasFieldPage)this.plugin()).isFieldBindingValid();
        boolean isFactFieldValid = !DecisionTableColumnViewUtils.nil(((HasFieldPage)this.plugin()).getFactField()) || this.isConstraintValuePredicate();
        boolean isComplete = isFactFieldValid && isFieldBindingValid;
        this.fieldBindingWarningToggle(isFieldBindingValid);
        this.factFieldWarningToggle(isFactFieldValid);
        callback.callback((Object)isComplete);
    }

    void fieldBindingWarningToggle(boolean isFieldBindingValid) {
        if (!isFieldBindingValid) {
            this.view.showFieldBindingWarning();
        } else {
            this.view.hideFieldBindingWarning();
        }
    }

    void factFieldWarningToggle(boolean isFactFieldValid) {
        if (!isFactFieldValid) {
            this.view.showSelectFieldWarning();
        } else {
            this.view.hideSelectFieldWarning();
        }
    }

    public void prepareView() {
        this.view.init(this);
        this.setupPatternWarningMessages();
        this.setupPredicateBindingInfoBox();
        this.setupBinding();
        this.setupField();
    }

    void setupField() {
        if (this.isConstraintValuePredicate()) {
            this.setupPredicateFieldView();
        } else {
            this.setupListFieldView();
        }
    }

    private void setupPredicateFieldView() {
        this.view.enablePredicateFieldView();
        this.view.setField(this.getFactField());
    }

    private void setupListFieldView() {
        this.view.enableListFieldView();
        this.view.setupEmptyFieldList();
        this.forEachFactField(field -> this.view.addItem((String)field, (String)field));
        this.view.selectField(this.getFactField());
    }

    void setupPatternWarningMessages() {
        boolean showWarningMessage = !this.hasEditingPattern();
        this.view.patternWarningToggle(showWarningMessage);
    }

    void setEditingCol(String selectedValue) {
        ((HasFieldPage)this.plugin()).setFactField(selectedValue);
    }

    void forEachFactField(Consumer<String> consumer) {
        if (this.hasEditingPattern()) {
            AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
            oracle.getFieldCompletions(this.factType(), this.getAccessor(), this.fieldsCallback(consumer));
        }
    }

    private FieldAccessorsAndMutators getAccessor() {
        return ((HasFieldPage)this.plugin()).getAccessor();
    }

    void setupPredicateBindingInfoBox() {
        boolean isConstraintValuePredicate;
        boolean bl = isConstraintValuePredicate = this.constraintValue() == 5;
        if (isConstraintValuePredicate) {
            this.view.showPredicateBindingInfo();
        } else {
            this.view.hidePredicateBindingInfo();
        }
    }

    void setupBinding() {
        if (this.canSetupBinding()) {
            this.view.setupBinding((IsWidget)this.newBindingTextBox());
        }
        this.view.bindingToggle(this.canSetupBinding());
    }

    TextBox newBindingTextBox() {
        BindingTextBox bindingTextBox = (BindingTextBox)GWT.create(BindingTextBox.class);
        bindingTextBox.setText(((HasFieldPage)this.plugin()).getBinding());
        bindingTextBox.addKeyUpHandler(event -> ((HasFieldPage)this.plugin()).setBinding(bindingTextBox.getText()));
        return bindingTextBox;
    }

    boolean canSetupBinding() {
        return ((HasFieldPage)this.plugin()).isBindable();
    }

    Callback<ModelField[]> fieldsCallback(Consumer<String> consumer) {
        AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
        return modelFields -> {
            List<String> fieldNames = this.collectNames((ModelField[])modelFields);
            if (this.filterEnumFields()) {
                fieldNames.stream().filter(fieldName -> !oracle.hasEnums(this.factType(), fieldName)).forEach(consumer);
            } else {
                fieldNames.forEach(consumer);
            }
        };
    }

    boolean isConstraintValuePredicate() {
        return this.constraintValue() == 5;
    }

    private int constraintValue() {
        return ((HasFieldPage)this.plugin()).constraintValue();
    }

    boolean filterEnumFields() {
        return ((HasFieldPage)this.plugin()).filterEnumFields();
    }

    boolean hasEditingPattern() {
        return !DecisionTableColumnViewUtils.nil(this.factType());
    }

    String factType() {
        return ((HasFieldPage)this.plugin()).patternWrapper().getFactType();
    }

    private List<String> collectNames(ModelField[] modelFields) {
        return Stream.of(modelFields).map(ModelField::getName).collect(Collectors.toList());
    }

    public String getFactField() {
        return ((HasFieldPage)this.plugin()).getFactField();
    }

    public static interface View
    extends HasList,
    UberElement<FieldPage> {
        public void patternWarningToggle(boolean var1);

        public void setupEmptyFieldList();

        public void selectField(String var1);

        public void setField(String var1);

        public void showSelectFieldWarning();

        public void hideSelectFieldWarning();

        public void enableListFieldView();

        public void enablePredicateFieldView();

        public void setupBinding(IsWidget var1);

        public void showFieldBindingWarning();

        public void hideFieldBindingWarning();

        public void showPredicateBindingInfo();

        public void hidePredicateBindingInfo();

        public void bindingToggle(boolean var1);
    }
}

