/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.MetaDataColumnPlugin;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class MetaDataColumnPage
extends BaseDecisionTableColumnPage<MetaDataColumnPlugin> {
    private View view;
    Caller<ValidationService> validationService;

    @Inject
    public MetaDataColumnPage(View view, TranslationService translationService, Caller<ValidationService> validationService) {
        super(translationService);
        this.view = view;
        this.validationService = validationService;
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public String getTitle() {
        return this.translate("MetaDataColumnPage.AddNewMetadata", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isUnique;
        String metadata = ((MetaDataColumnPlugin)this.plugin()).getMetaData();
        boolean hasMetaData = !DecisionTableColumnViewUtils.nil(metadata);
        boolean bl = isUnique = hasMetaData && this.presenter.isMetaDataUnique(metadata);
        if (!hasMetaData) {
            this.view.showError(this.translate("MetaDataColumnPage.MetadataNameEmpty", new Object[0]));
        } else if (!isUnique) {
            this.view.showError(this.translate("MetaDataColumnPage.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]));
        }
        if (isUnique) {
            this.isValidIdentifier(metadata, callback);
        } else {
            callback.callback((Object)false);
        }
    }

    public void prepareView() {
        this.view.init(this);
        this.view.clear();
    }

    public String getMetadata() {
        return ((MetaDataColumnPlugin)this.plugin()).getMetaData();
    }

    public void setMetadata(String metadata) {
        ((MetaDataColumnPlugin)this.plugin()).setMetaData(metadata.trim());
    }

    private void isValidIdentifier(final String text, final Callback<Boolean> callback) {
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Map<String, Boolean>>(){

            public void callback(Map<String, Boolean> evaluatedIdentifiers) {
                if (!evaluatedIdentifiers.get(text).booleanValue()) {
                    MetaDataColumnPage.this.view.showError(MetaDataColumnPage.this.translate("MetaDataColumnPage.IsNotValidIdentifier", new Object[0]));
                    callback.callback((Object)false);
                } else {
                    MetaDataColumnPage.this.view.hideError();
                    callback.callback((Object)true);
                }
            }
        })).evaluateJavaIdentifiers(new String[]{text});
    }

    public static interface View
    extends UberElement<MetaDataColumnPage> {
        public void showError(String var1);

        public void hideError();

        public void clear();
    }
}

