/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class NewPatternPresenter {
    private final View view;
    private TranslationService translationService;
    private PatternPage<? extends HasPatternPage> patternPage;

    @Inject
    public NewPatternPresenter(View view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show() {
        this.view.clear();
        if (!this.patternPage.isNegatedPatternEnabled()) {
            this.view.disableNegatedPattern();
        }
        this.view.show();
    }

    public void hide() {
        this.view.hide();
    }

    public void init(PatternPage patternPage) {
        this.patternPage = patternPage;
    }

    public List<String> getFactTypes() {
        return Arrays.asList(this.oracle().getFactTypes());
    }

    void cancel() {
        this.view.hide();
    }

    void addPattern() {
        if (!this.isValid()) {
            return;
        }
        this.setEditingPattern();
        this.updatePatternPageView();
        this.hide();
    }

    boolean isBindingUnique(String binding) {
        BRLRuleModel brlRuleModel = new BRLRuleModel(this.model());
        return !brlRuleModel.isVariableNameUsed(binding);
    }

    PatternWrapper pattern52() {
        return new PatternWrapper(this.factType(), this.factName(), this.isNegatePatternMatch());
    }

    private void updatePatternPageView() {
        this.patternPage.prepareView();
    }

    private boolean isValid() {
        if (!this.isNegatePatternMatch()) {
            if (DecisionTableColumnViewUtils.nil(this.factName())) {
                this.view.showError(this.translate("NewPatternPresenter.PleaseEnterANameForFact", new Object[0]));
                return false;
            }
            if (this.factName().equals(this.factType())) {
                this.view.showError(this.translate("NewPatternPresenter.PleaseEnterANameThatIsNotTheSameAsTheFactType", new Object[0]));
                return false;
            }
            if (!this.isBindingUnique(this.factName())) {
                this.view.showError(this.translate("NewPatternPresenter.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern", new Object[0]));
                return false;
            }
        }
        this.view.hideError();
        return true;
    }

    private void setEditingPattern() {
        this.patternPage.setEditingPattern(this.pattern52());
    }

    private String factName() {
        return this.isNegatePatternMatch() ? "" : this.view.getBindingText();
    }

    private String factType() {
        return this.view.getSelectedFactType();
    }

    private boolean isNegatePatternMatch() {
        return this.view.isNegatePatternMatch();
    }

    private AsyncPackageDataModelOracle oracle() {
        return this.patternPage.presenter().getDataModelOracle();
    }

    private GuidedDecisionTable52 model() {
        return this.patternPage.presenter().getModel();
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    public static interface View
    extends UberElement<NewPatternPresenter> {
        public void show();

        public void hide();

        public void clear();

        public boolean isNegatePatternMatch();

        public String getSelectedFactType();

        public String getBindingText();

        public void showError(String var1);

        public void hideError();

        public void disableNegatedPattern();
    }
}

