/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.screens.guided.dtree.backend.server.indexing.TestGuidedDecisionTreeFileIndexer;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.kie.uberfire.metadata.engine.Index;
import org.kie.uberfire.metadata.io.KObjectUtil;
import org.kie.uberfire.metadata.model.KObject;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexRuleMultipleTypesTest
extends BaseIndexingTest<GuidedDTreeResourceTypeDefinition> {
    @Test
    public void testIndexDrlRuleMultipleTypes() throws IOException, InterruptedException {
        int i;
        Path path1 = this.basePath.resolve("drl3.tdrl");
        String drl1 = this.loadText("drl3.tdrl");
        this.ioService().write(path1, drl1, new OpenOption[0]);
        Path path2 = this.basePath.resolve("drl4.tdrl");
        String drl2 = this.loadText("drl4.tdrl");
        this.ioService().write(path2, drl2, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexRuleMultipleTypesTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        Query query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.guided.dtree.backend.server.indexing.classes.Applicant")).build();
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        ArrayList<KObject> results = new ArrayList<KObject>();
        for (i = 0; i < hits.length; ++i) {
            results.add(org.kie.uberfire.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path1);
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
        searcher = ((LuceneIndex)index).nrtSearcher();
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.guided.dtree.backend.server.indexing.classes.Mortgage")).build();
        searcher.search(query, (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        results = new ArrayList();
        for (i = 0; i < hits.length; ++i) {
            results.add(org.kie.uberfire.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedDecisionTreeFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("rule_attribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected GuidedDTreeResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedDTreeResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

