/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server.indexing;

import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.ErrorMessageUtilities;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.PackageDescrIndexVisitor;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedDecisionTreeFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(GuidedDecisionTreeFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected GuidedDTreeResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            String drl = this.ioService.readAllString(path);
            DrlParser drlParser = new DrlParser();
            PackageDescr packageDescr = drlParser.parse(true, drl);
            if (drlParser.hasErrors()) {
                List errors = drlParser.getErrors();
                logger.warn(ErrorMessageUtilities.makeErrorMessage((Path)path, (DroolsError[])errors.toArray(new DroolsError[errors.size()])));
                return index;
            }
            if (packageDescr == null) {
                logger.warn(ErrorMessageUtilities.makeErrorMessage((Path)path, (DroolsError[])new DroolsError[0]));
                return index;
            }
            ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
            Project project = this.projectService.resolveProject(Paths.convert((Path)path));
            Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
            DefaultIndexBuilder builder = new DefaultIndexBuilder(project, pkg);
            PackageDescrIndexVisitor visitor = new PackageDescrIndexVisitor(dmo, builder, packageDescr);
            visitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Throwable)e);
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }
}

