/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server.indexing;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.guided.dtree.backend.server.indexing.TestGuidedDecisionTreeFileIndexer;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexRuleMultipleTypesTest
extends BaseIndexingTest<GuidedDTreeResourceTypeDefinition> {
    @Test
    public void testIndexDrlRuleMultipleTypes() throws IOException, InterruptedException {
        Path path1 = this.basePath.resolve("drl3.tdrl");
        String drl1 = this.loadText("drl3.tdrl");
        this.ioService().write(path1, drl1, new OpenOption[0]);
        Path path2 = this.basePath.resolve("drl4.tdrl");
        String drl2 = this.loadText("drl4.tdrl");
        this.ioService().write(path2, drl2, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexRuleMultipleTypesTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("org.drools.workbench.screens.guided.dtree.backend.server.indexing.classes.Applicant", ResourceType.JAVA)).build();
        this.searchFor(index, query, 2, new Path[]{path1, path2});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("org.drools.workbench.screens.guided.dtree.backend.server.indexing.classes.Mortgage", ResourceType.JAVA)).build();
        this.searchFor(index, query, 1, new Path[]{path2});
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedDecisionTreeFileIndexer();
    }

    protected GuidedDTreeResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedDTreeResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

