/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server.indexing;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.guided.dtree.backend.server.indexing.TestGuidedDecisionTreeFileIndexer;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexRuleTest
extends BaseIndexingTest<GuidedDTreeResourceTypeDefinition> {
    @Test
    public void testIndexDrlRules() throws IOException, InterruptedException {
        Path path = this.basePath.resolve("drl1.tdrl");
        String drl = this.loadText("drl1.tdrl");
        this.ioService().write(path, drl, new OpenOption[0]);
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueResourceIndexTerm("*myRule", ResourceType.RULE, ValueIndexTerm.TermSearchType.WILDCARD)).build();
        this.searchFor(index, query, 1, new Path[0]);
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedDecisionTreeFileIndexer();
    }

    protected GuidedDTreeResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedDTreeResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

