/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.models.guided.dtree.shared.model.parser.GuidedDecisionTreeParserError;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.AmbiguousRootParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.BindingNotFoundParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.DataTypeConversionErrorParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.DataTypeNotFoundParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.DefaultParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.InvalidRootParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.ParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.UnsupportedFieldConstraintParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.UnsupportedFieldConstraintTypeParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.UnsupportedFieldNatureTypeParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.UnsupportedIActionParserMessage;
import org.drools.workbench.models.guided.dtree.shared.model.parser.messages.UnsupportedIPatternParserMessage;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.messageconsole.client.console.widget.MessageTableWidget;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

public class ParserMessagesPopup
extends BaseModal {
    private static ParserMessagesBinder uiBinder = (ParserMessagesBinder)GWT.create(ParserMessagesBinder.class);
    private final GenericModalFooter footer = new GenericModalFooter();
    @UiField(provided=true)
    MessageTableWidget<Pair<String, ParserMessage>> messages;
    @UiField
    ViewDRLSourceWidget drlPreview;
    private final GuidedDecisionTree model;
    private final List<Pair<String, ParserMessage>> errors = new ArrayList<Pair<String, ParserMessage>>();

    public ParserMessagesPopup(final GuidedDecisionTree model) {
        this.model = (GuidedDecisionTree)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        for (GuidedDecisionTreeParserError error : model.getParserErrors()) {
            for (ParserMessage msg : error.getMessages()) {
                this.errors.add((Pair<String, ParserMessage>)Pair.newPair((Object)error.getOriginalDrl(), (Object)msg));
            }
        }
        this.setTitle(GuidedDecisionTreeConstants.INSTANCE.popupTitleParserMessages());
        this.messages = new MessageTableWidget();
        this.messages.setToolBarVisible(false);
        this.messages.setHeight("150px");
        this.footer.addButton(GuidedDecisionTreeConstants.INSTANCE.remove(), new Command(){

            public void execute() {
                model.getParserErrors().clear();
                ParserMessagesPopup.this.hide();
            }
        }, IconType.WARNING, ButtonType.DANGER);
        this.footer.addButton(GuidedDecisionTreeConstants.INSTANCE.ignore(), new Command(){

            public void execute() {
                ParserMessagesPopup.this.hide();
            }
        }, ButtonType.PRIMARY);
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.messages.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<Pair<String, ParserMessage>>(){

            public void onCellPreview(CellPreviewEvent<Pair<String, ParserMessage>> event) {
                if (Event.getTypeInt((String)event.getNativeEvent().getType()) == 1) {
                    ParserMessagesPopup.this.drlPreview.setContent((String)((Pair)event.getValue()).getK1());
                }
            }
        });
        this.messages.setRowData(this.errors);
        this.messages.addLevelColumn(10, (MessageTableWidget.ColumnExtractor)new MessageTableWidget.ColumnExtractor<Level>(){

            public Level getValue(Object row) {
                return Level.ERROR;
            }
        });
        this.messages.addTextColumn(90, (MessageTableWidget.ColumnExtractor)new MessageTableWidget.ColumnExtractor<String>(){

            public String getValue(Object row) {
                return ParserMessagesPopup.this.getMessage((ParserMessage)((Pair)row).getK2());
            }
        });
    }

    private String getMessage(ParserMessage msg) {
        if (msg instanceof AmbiguousRootParserMessage) {
            TypeNode tn = this.model.getRoot();
            AmbiguousRootParserMessage m = (AmbiguousRootParserMessage)msg;
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageAmbiguousRootParserMessage(tn.getClassName(), m.getClassName());
        }
        if (msg instanceof BindingNotFoundParserMessage) {
            BindingNotFoundParserMessage m = (BindingNotFoundParserMessage)msg;
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageBindingNotFoundParserMessage(m.getBinding());
        }
        if (msg instanceof DataTypeConversionErrorParserMessage) {
            DataTypeConversionErrorParserMessage m = (DataTypeConversionErrorParserMessage)msg;
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageDataTypeConversionErrorParserMessage(m.getValue(), m.getDataTypeClassName());
        }
        if (msg instanceof DataTypeNotFoundParserMessage) {
            DataTypeNotFoundParserMessage m = (DataTypeNotFoundParserMessage)msg;
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageDataTypeNotFoundParserMessage(m.getClassName(), m.getFieldName());
        }
        if (msg instanceof DefaultParserMessage) {
            DefaultParserMessage m = (DefaultParserMessage)msg;
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageDefaultParserMessage(m.getMessage());
        }
        if (msg instanceof InvalidRootParserMessage) {
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageInvalidRootParserMessage();
        }
        if (msg instanceof UnsupportedFieldConstraintParserMessage) {
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageUnsupportedFieldConstraintParserMessage();
        }
        if (msg instanceof UnsupportedFieldConstraintTypeParserMessage) {
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageUnsupportedFieldConstraintTypeParserMessage();
        }
        if (msg instanceof UnsupportedFieldNatureTypeParserMessage) {
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageUnsupportedFieldNatureTypeParserMessage();
        }
        if (msg instanceof UnsupportedIActionParserMessage) {
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageUnsupportedIActionParserMessage();
        }
        if (msg instanceof UnsupportedIPatternParserMessage) {
            return GuidedDecisionTreeConstants.INSTANCE.parserMessageUnsupportedIPatternParserMessage();
        }
        return GuidedDecisionTreeConstants.INSTANCE.parserMessageUnknownMessage();
    }

    static interface ParserMessagesBinder
    extends UiBinder<Widget, ParserMessagesPopup> {
    }
}

