/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.factories;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.TextMetrics;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.Color;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.categories.GuidedDecisionTreeEditorCategory;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.ConstraintShape;
import org.uberfire.ext.wires.core.api.factories.FactoryHelper;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxy;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxyCompleteCallback;
import org.uberfire.ext.wires.core.api.factories.ShapeDragProxyPreviewCallback;
import org.uberfire.ext.wires.core.api.factories.categories.Category;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.factories.AbstractBaseFactory;

public abstract class BaseGuidedDecisionTreeNodeFactory<T extends Shape<T>>
extends AbstractBaseFactory<T> {
    public Category getCategory() {
        return GuidedDecisionTreeEditorCategory.CATEGORY;
    }

    public ShapeDragProxy getDragProxy(FactoryHelper helper, final ShapeDragProxyPreviewCallback dragPreviewCallback, final ShapeDragProxyCompleteCallback dragEndCallBack) {
        Shape shape = this.makeShape();
        final Group group = new Group();
        group.add((IPrimitive)shape);
        double dragProxyWidth = this.getWidth();
        double dragProxyHeight = this.getHeight();
        String description = this.getNodeLabel(helper);
        if (description != null) {
            Text nodeLabel = new Text(description, "oblique normal", 10.0);
            nodeLabel.setTextAlign(TextAlign.CENTER);
            nodeLabel.setTextBaseLine(TextBaseLine.MIDDLE);
            nodeLabel.setFillColor(Color.rgbToBrowserHexColor((int)0, (int)0, (int)0));
            dragProxyWidth = this.getDragProxyWidth(nodeLabel);
            dragProxyHeight = this.getDragProxyHeight(nodeLabel);
            group.add((IPrimitive)nodeLabel);
        }
        final double _dragProxyWidth = dragProxyWidth;
        final double _dragProxyHeight = dragProxyHeight;
        return new ShapeDragProxy(){

            public Group getDragGroup() {
                return group;
            }

            public void onDragPreview(double x, double y) {
                dragPreviewCallback.callback(x, y);
            }

            public void onDragComplete(double x, double y) {
                dragEndCallBack.callback(x, y);
            }

            public double getWidth() {
                return _dragProxyWidth;
            }

            public double getHeight() {
                return _dragProxyHeight;
            }
        };
    }

    protected abstract String getNodeLabel(FactoryHelper var1);

    private double getDragProxyWidth(Text nodeLabel) {
        LienzoPanel panel = new LienzoPanel(100, 100);
        Layer layer = new Layer();
        panel.add(layer);
        TextMetrics tm = nodeLabel.measure(layer.getContext());
        return Math.max(this.getWidth(), tm.getWidth());
    }

    private double getDragProxyHeight(Text nodeLabel) {
        LienzoPanel panel = new LienzoPanel(100, 100);
        Layer layer = new Layer();
        panel.add(layer);
        TextMetrics tm = nodeLabel.measure(layer.getContext());
        return Math.max(this.getHeight(), tm.getHeight());
    }

    public boolean builds(WiresBaseShape shapeType) {
        return shapeType instanceof ConstraintShape;
    }
}

