/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.TreeMap;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionRetractNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.ActionRetractNodeImpl;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditActionRetractPopup
extends BaseModal {
    private static EditActionRetractBinder uiBinder = (EditActionRetractBinder)GWT.create(EditActionRetractBinder.class);
    private final ActionRetractNode node;
    private final ActionRetractNode clone;
    private final Command callback;
    private final Command okCommand = new Command(){

        public void execute() {
            EditActionRetractPopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            EditActionRetractPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);
    @UiField
    FormGroup bindingGroup;
    @UiField
    ListBox bindingListBox;

    public EditActionRetractPopup(ActionRetractNode node, Command callback) {
        this.setTitle(GuidedDecisionTreeConstants.INSTANCE.popupTitleEditActionRetract());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.node = node;
        this.clone = this.cloneNode(node);
        this.callback = callback;
        this.initialiseBoundTypes();
    }

    private ActionRetractNode cloneNode(ActionRetractNode node) {
        ActionRetractNodeImpl clone = new ActionRetractNodeImpl(node.getBoundNode());
        clone.setParent(node.getParent());
        return clone;
    }

    private void initialiseBoundTypes() {
        final TreeMap<String, TypeNode> bindings = new TreeMap<String, TypeNode>();
        for (Node parent = this.clone.getParent(); parent != null; parent = parent.getParent()) {
            TypeNode tn;
            if (!(parent instanceof TypeNode) || !(tn = (TypeNode)parent).isBound()) continue;
            bindings.put(tn.getBinding(), tn);
        }
        this.bindingListBox.setEnabled(!bindings.isEmpty());
        if (bindings.isEmpty()) {
            this.bindingListBox.addItem(GuidedDecisionTreeConstants.INSTANCE.noBindings());
            return;
        }
        int selectedIndex = 0;
        TypeNode boundNode = this.clone.getBoundNode();
        for (String binding : bindings.keySet()) {
            this.bindingListBox.addItem(binding);
            if (boundNode == null || !binding.equals(boundNode.getBinding())) continue;
            selectedIndex = this.bindingListBox.getItemCount() - 1;
        }
        this.bindingListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String binding = EditActionRetractPopup.this.bindingListBox.getItemText(EditActionRetractPopup.this.bindingListBox.getSelectedIndex());
                EditActionRetractPopup.this.clone.setBoundNode((TypeNode)bindings.get(binding));
            }
        });
        this.bindingListBox.setSelectedIndex(selectedIndex);
    }

    private void onOKButtonClick() {
        this.node.setBoundNode(this.clone.getBoundNode());
        if (this.callback != null) {
            this.callback.execute();
        }
        this.hide();
    }

    static interface EditActionRetractBinder
    extends UiBinder<Widget, EditActionRetractPopup> {
    }
}

