/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.shapes;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.shape.Circle;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Picture;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.Color;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import com.google.gwt.resources.client.ImageResource;
import java.util.ArrayList;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.screens.guided.dtree.client.editor.GuidedDecisionTreeEditorPresenter;
import org.drools.workbench.screens.guided.dtree.client.resources.GuidedDecisionTreeResources;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.NodeLabel;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.trees.client.shapes.WiresBaseTreeNode;
import org.uberfire.mvp.Command;

public abstract class BaseGuidedDecisionTreeShape<T extends Node>
extends WiresBaseTreeNode {
    private static final int BOUNDARY_SIZE = 10;
    private final Circle circle;
    private final Circle bounding;
    protected final Text plus = new Text("+", "normal", 50.0);
    protected NodeLabel nodeLabel = new NodeLabel();
    private Group ctrlGroupDeleteIcon;
    private Group ctrlGroupEditIcon;
    private Group ctrlGroupCollapseIcon;
    private Group ctrlGroupExpandIcon;
    protected final T node;
    protected boolean isReadOnly;
    private GuidedDecisionTreeEditorPresenter presenter;

    public BaseGuidedDecisionTreeShape(Circle shape, T node, boolean isReadOnly) {
        this.circle = shape;
        this.node = node;
        this.isReadOnly = isReadOnly;
        this.bounding = new Circle(this.circle.getRadius() + 5.0);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.1);
        this.plus.setTextAlign(TextAlign.CENTER);
        this.plus.setTextBaseLine(TextBaseLine.MIDDLE);
        this.plus.setStrokeWidth(2.0);
        this.add((IPrimitive)this.circle);
        this.add((IPrimitive)this.nodeLabel);
        this.nodeLabel.addNodeMouseClickHandler(new NodeMouseClickHandler(){

            public void onNodeMouseClick(NodeMouseClickEvent nodeMouseClickEvent) {
                BaseGuidedDecisionTreeShape.this.selectionManager.selectShape((WiresBaseShape)BaseGuidedDecisionTreeShape.this);
            }
        });
        if (!isReadOnly) {
            this.setupControls();
        }
    }

    public void setPresenter(GuidedDecisionTreeEditorPresenter presenter) {
        this.presenter = presenter;
    }

    protected void setupControls() {
        this.ctrlGroupDeleteIcon = this.setupControl(GuidedDecisionTreeResources.INSTANCE.images().ctrlDelete(), new Command(){

            public void execute() {
                BaseGuidedDecisionTreeShape.this.shapesManager.deleteShape((WiresBaseShape)BaseGuidedDecisionTreeShape.this);
            }
        });
        this.ctrlGroupEditIcon = this.setupControl(GuidedDecisionTreeResources.INSTANCE.images().ctrlEdit(), new Command(){

            public void execute() {
                BaseGuidedDecisionTreeShape.this.presenter.editModelNode((Node)BaseGuidedDecisionTreeShape.this.getModelNode(), new Command(){

                    public void execute() {
                        this.updateLabels(BaseGuidedDecisionTreeShape.this);
                        BaseGuidedDecisionTreeShape.this.getLayer().batch();
                    }

                    private void updateLabels(BaseGuidedDecisionTreeShape parent) {
                        parent.setNodeLabel(parent.getNodeLabel());
                        for (WiresBaseTreeNode child : parent.getChildren()) {
                            if (!(child instanceof BaseGuidedDecisionTreeShape)) continue;
                            BaseGuidedDecisionTreeShape cs = (BaseGuidedDecisionTreeShape)child;
                            cs.setNodeLabel(cs.getNodeLabel());
                            this.updateLabels(cs);
                        }
                    }
                });
            }
        });
        this.ctrlGroupCollapseIcon = this.setupControl(GuidedDecisionTreeResources.INSTANCE.images().ctrlCollapse(), new Command(){

            public void execute() {
                BaseGuidedDecisionTreeShape.this.collapse(new Command(){

                    public void execute() {
                    }
                });
                ArrayList<Group> controls = new ArrayList<Group>(){
                    {
                        this.add(BaseGuidedDecisionTreeShape.this.ctrlGroupDeleteIcon);
                        this.add(BaseGuidedDecisionTreeShape.this.ctrlGroupExpandIcon);
                    }
                };
                BaseGuidedDecisionTreeShape.this.setControls(controls);
            }
        });
        this.ctrlGroupExpandIcon = this.setupControl(GuidedDecisionTreeResources.INSTANCE.images().ctrlExpand(), new Command(){

            public void execute() {
                BaseGuidedDecisionTreeShape.this.expand(new Command(){

                    public void execute() {
                    }
                });
                ArrayList<Group> controls = new ArrayList<Group>(){
                    {
                        this.add(BaseGuidedDecisionTreeShape.this.ctrlGroupDeleteIcon);
                        this.add(BaseGuidedDecisionTreeShape.this.ctrlGroupEditIcon);
                        this.add(BaseGuidedDecisionTreeShape.this.ctrlGroupCollapseIcon);
                    }
                };
                BaseGuidedDecisionTreeShape.this.setControls(controls);
            }
        });
        this.controls.add(this.ctrlGroupDeleteIcon);
        this.controls.add(this.ctrlGroupEditIcon);
    }

    protected Group setupControl(ImageResource resource, final Command command) {
        Group controlGroup = new Group();
        new Picture(resource, picture1 -> {
            double offsetX = -picture1.getImageData().getWidth() / 2;
            double offsetY = -picture1.getImageData().getHeight() / 2;
            Rectangle selector = new Rectangle((double)picture1.getImageData().getWidth(), (double)picture1.getImageData().getHeight());
            selector.setFillColor(Color.rgbToBrowserHexColor((int)255, (int)255, (int)255));
            selector.setAlpha(0.01);
            selector.setLocation(new Point2D(offsetX, offsetY));
            picture1.setLocation(new Point2D(offsetX, offsetY));
            controlGroup.add((IPrimitive)picture1);
            controlGroup.add((IPrimitive)selector);
        }, false);
        controlGroup.addNodeMouseClickHandler(new NodeMouseClickHandler(){

            public void onNodeMouseClick(NodeMouseClickEvent nodeMouseClickEvent) {
                command.execute();
            }
        });
        return controlGroup;
    }

    protected void setNodeLabel(String label) {
        this.nodeLabel.setLabel(label);
    }

    protected abstract String getNodeLabel();

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.bounding);
            if (!this.isReadOnly) {
                this.showControls();
            }
        } else {
            this.remove((IPrimitive)this.bounding);
            if (!this.isReadOnly) {
                this.hideControls();
            }
        }
    }

    public void addChildNode(WiresBaseTreeNode child) {
        boolean hasChildren = this.hasChildren();
        super.addChildNode(child);
        if (!hasChildren && this.hasChildren()) {
            this.addControl(this.ctrlGroupCollapseIcon);
        }
    }

    protected Point2D getControlTarget(Group ctrl) {
        Point2D target = super.getControlTarget(ctrl);
        target.setX(this.circle.getRadius() + 25.0);
        return target;
    }

    public void onCollapseStart() {
        this.add((IPrimitive)this.plus);
        this.nodeLabel.moveToTop();
        this.plus.setAlpha(0.0);
    }

    public void onCollapseProgress(double pct) {
        this.plus.setAlpha(pct);
    }

    public void onExpandProgress(double pct) {
        this.plus.setAlpha(1.0 - pct);
    }

    public void onExpandEnd() {
        this.remove((IPrimitive)this.plus);
    }

    public double getWidth() {
        return this.circle.getRadius() * 2.0;
    }

    public double getHeight() {
        return this.circle.getRadius() * 2.0;
    }

    public T getModelNode() {
        return this.node;
    }
}

