/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.utils;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.workbench.models.guided.dtree.shared.model.values.Value;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.BigDecimalValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.BigIntegerValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.BooleanValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.ByteValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.DateValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.DoubleValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.EnumValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.FloatValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.IntegerValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.LongValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.ShortValue;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.StringValue;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

public class ValueUtilities {
    private static final String DROOLS_DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMAT = DateTimeFormat.getFormat((String)DROOLS_DATE_FORMAT);

    public static String convertNodeValue(Value value) {
        if (value == null) {
            return "";
        }
        if (value instanceof DateValue) {
            DateValue dv = (DateValue)value;
            return DATE_FORMAT.format(dv.getValue());
        }
        return value.getValue().toString();
    }

    public static Value makeEmptyValue(String dataType) {
        if ("String".equals(dataType)) {
            return new StringValue(new String());
        }
        if ("Numeric".equals(dataType)) {
            return new BigDecimalValue(new BigDecimal(0));
        }
        if ("BigDecimal".equals(dataType)) {
            return new BigDecimalValue(new BigDecimal(0));
        }
        if ("BigInteger".equals(dataType)) {
            return new BigIntegerValue(new BigInteger("0"));
        }
        if ("Byte".equals(dataType)) {
            return new ByteValue(new Byte("0"));
        }
        if ("Double".equals(dataType)) {
            return new DoubleValue(Double.valueOf(0.0));
        }
        if ("Float".equals(dataType)) {
            return new FloatValue(Float.valueOf(0.0f));
        }
        if ("Integer".equals(dataType)) {
            return new IntegerValue(Integer.valueOf(0));
        }
        if ("Long".equals(dataType)) {
            return new LongValue(Long.valueOf(0L));
        }
        if ("Short".equals(dataType)) {
            return new ShortValue(new Short("0"));
        }
        if ("Boolean".equals(dataType)) {
            return new BooleanValue(Boolean.FALSE);
        }
        if ("Date".equals(dataType)) {
            return new DateValue(new Date());
        }
        if ("Comparable".equals(dataType)) {
            return new EnumValue(new String());
        }
        return null;
    }

    public static Value clone(Value value) {
        if (value instanceof StringValue) {
            return new StringValue(((StringValue)value).getValue());
        }
        if (value instanceof BigDecimalValue) {
            return new BigDecimalValue(((BigDecimalValue)value).getValue());
        }
        if (value instanceof BigIntegerValue) {
            return new BigIntegerValue(((BigIntegerValue)value).getValue());
        }
        if (value instanceof ByteValue) {
            return new ByteValue(((ByteValue)value).getValue());
        }
        if (value instanceof DoubleValue) {
            return new DoubleValue(((DoubleValue)value).getValue());
        }
        if (value instanceof FloatValue) {
            return new FloatValue(((FloatValue)value).getValue());
        }
        if (value instanceof IntegerValue) {
            return new IntegerValue(((IntegerValue)value).getValue());
        }
        if (value instanceof LongValue) {
            return new LongValue(((LongValue)value).getValue());
        }
        if (value instanceof ShortValue) {
            return new ShortValue(((ShortValue)value).getValue());
        }
        if (value instanceof BooleanValue) {
            return new BooleanValue(((BooleanValue)value).getValue());
        }
        if (value instanceof DateValue) {
            return new DateValue(((DateValue)value).getValue());
        }
        return null;
    }
}

