/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget.popups;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionFieldValue;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.HasValue;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.ActionFieldValueImpl;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.ActionFieldValueEditor;
import org.drools.workbench.screens.guided.dtree.client.widget.popups.ValueEditorFactory;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionFieldValueEditorTest {
    private static final String FACT_TYPE = "MyFact";
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private ParameterizedCommand<ActionFieldValue> onDeleteCallback;
    @Mock
    private ValueEditorFactory valueEditorFactory;
    @Mock
    private Widget widget;
    @GwtMock
    private ListBox fieldListBox;
    @GwtMock
    private FormGroup valueHolder;
    private ActionFieldValue afv = new ActionFieldValueImpl();
    private List<ActionFieldValue> afvs = Collections.emptyList();
    private ActionFieldValueEditor editor;

    @Before
    public void setup() {
        Mockito.when((Object)this.valueEditorFactory.getValueEditor(Mockito.anyString(), Mockito.anyString(), (HasValue)Matchers.any(HasValue.class), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle), Mockito.anyBoolean())).thenReturn((Object)this.widget);
    }

    @Test
    public void checkInitializeFieldNamesWithoutModelFields() {
        this.initialiseDataModelOracle(new ModelField[0]);
        this.editor = new ActionFieldValueEditorFake(FACT_TYPE, this.afv, this.afvs, this.oracle, this.onDeleteCallback);
        ((ListBox)Mockito.verify((Object)this.fieldListBox, (VerificationMode)Mockito.atLeast((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ListBox)Mockito.verify((Object)this.fieldListBox, (VerificationMode)Mockito.never())).setEnabled(Matchers.eq((boolean)true));
        ((ListBox)Mockito.verify((Object)this.fieldListBox)).addItem((String)Matchers.eq((Object)GuidedDecisionTreeConstants.INSTANCE.noFields()));
    }

    @Test
    public void checkInitializeFieldNamesWithModelFields() {
        ModelField[] modelFields = new ModelField[]{new ModelField("field1", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "String")};
        this.initialiseDataModelOracle(modelFields);
        ((ListBox)Mockito.doAnswer(invocation -> {
            int index = (Integer)invocation.getArguments()[0];
            return modelFields[index].getName();
        }).when((Object)this.fieldListBox)).getItemText(Mockito.anyInt());
        this.editor = new ActionFieldValueEditorFake(FACT_TYPE, this.afv, this.afvs, this.oracle, this.onDeleteCallback);
        ((ListBox)Mockito.verify((Object)this.fieldListBox)).setEnabled(Matchers.eq((boolean)true));
        ((ListBox)Mockito.verify((Object)this.fieldListBox)).setSelectedIndex(Matchers.eq((int)0));
        ((FormGroup)Mockito.verify((Object)this.valueHolder)).clear();
        ((FormGroup)Mockito.verify((Object)this.valueHolder)).add((Widget)Matchers.eq((Object)this.widget));
    }

    private void initialiseDataModelOracle(ModelField[] modelFields) {
        ((AsyncPackageDataModelOracle)Mockito.doAnswer(invocation -> {
            Callback callback = (Callback)invocation.getArguments()[1];
            callback.callback((Object)modelFields);
            return null;
        }).when((Object)this.oracle)).getFieldCompletions((String)Matchers.eq((Object)FACT_TYPE), (Callback)Matchers.any(Callback.class));
    }

    private class ActionFieldValueEditorFake
    extends ActionFieldValueEditor {
        public ActionFieldValueEditorFake(String className, ActionFieldValue afv, List<ActionFieldValue> afvs, AsyncPackageDataModelOracle oracle, ParameterizedCommand<ActionFieldValue> onDeleteCallback) {
            super(className, afv, afvs, oracle, onDeleteCallback);
        }

        ValueEditorFactory valueEditorFactory() {
            return ActionFieldValueEditorTest.this.valueEditorFactory;
        }
    }
}

