/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.guided.dtree.client.handlers.NewGuidedDecisionTreeHandler;
import org.drools.workbench.screens.guided.dtree.client.type.GuidedDTreeResourceType;
import org.drools.workbench.screens.guided.dtree.service.GuidedDecisionTreeEditorService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewGuidedDecisionTreeHandlerTest {
    @Mock
    private GuidedDecisionTreeEditorService service;
    private Caller<GuidedDecisionTreeEditorService> serviceCaller;
    @Mock
    private BusyIndicatorView indicatorView;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private User user;
    @Captor
    private ArgumentCaptor<ResourceRef> refArgumentCaptor;
    private GuidedDTreeResourceType resourceType = new GuidedDTreeResourceType();
    private NewGuidedDecisionTreeHandler handler;

    @Before
    public void setup() {
        this.serviceCaller = new CallerMock((Object)this.service);
        this.handler = new NewGuidedDecisionTreeHandler(this.serviceCaller, this.resourceType, this.indicatorView, this.authorizationManager, this.sessionInfo);
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
    }

    @Test
    public void checkCanCreateWhenFeatureDisabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkCanCreateWhenFeatureEnabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    private void assertResourceRef() {
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)this.refArgumentCaptor.capture(), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user));
        Assert.assertEquals((Object)"GuidedDecisionTreeEditorPresenter", (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.EDITOR, (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getResourceType());
    }
}

