/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget;

import com.ait.lienzo.client.core.animation.AnimationProperties;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import com.google.gwt.user.client.Window;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionInsertNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionRetractNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionUpdateNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ConstraintNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.screens.guided.dtree.client.editor.GuidedDecisionTreeEditorPresenter;
import org.drools.workbench.screens.guided.dtree.client.resources.i18n.GuidedDecisionTreeConstants;
import org.drools.workbench.screens.guided.dtree.client.widget.GuidedDecisionTreeDropContext;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ActionInsertNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ActionRetractNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ActionUpdateNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ConstraintNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.TypeNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.BaseGuidedDecisionTreeShape;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.TypeShape;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.wires.core.api.events.ClearEvent;
import org.uberfire.ext.wires.core.api.events.ShapeAddedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDeletedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDragCompleteEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDragPreviewEvent;
import org.uberfire.ext.wires.core.api.events.ShapeSelectedEvent;
import org.uberfire.ext.wires.core.api.layout.LayoutManager;
import org.uberfire.ext.wires.core.api.layout.RequiresLayoutManager;
import org.uberfire.ext.wires.core.api.selection.SelectionManager;
import org.uberfire.ext.wires.core.api.shapes.ShapesManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.canvas.WiresCanvas;
import org.uberfire.ext.wires.core.trees.client.canvas.WiresTreeNodeConnector;
import org.uberfire.ext.wires.core.trees.client.layout.WiresLayoutUtilities;
import org.uberfire.ext.wires.core.trees.client.layout.treelayout.Rectangle2D;
import org.uberfire.ext.wires.core.trees.client.shapes.WiresBaseTreeNode;

public class GuidedDecisionTreeWidget
extends WiresCanvas
implements UberView<GuidedDecisionTreeEditorPresenter> {
    private static final int MAX_PROXIMITY = 200;
    private static final int ANIMATION_DURATION = 250;
    private Event<ClearEvent> clearEvent;
    private Event<ShapeSelectedEvent> shapeSelectedEvent;
    private Event<ShapeAddedEvent> shapeAddedEvent;
    private Event<ShapeDeletedEvent> shapeDeletedEvent;
    private LayoutManager layoutManager;
    private TypeNodeFactory typeNodeFactory;
    private ConstraintNodeFactory constraintNodeFactory;
    private ActionInsertNodeFactory actionInsertNodeFactory;
    private ActionUpdateNodeFactory actionUpdateNodeFactory;
    private ActionRetractNodeFactory actionRetractNodeFactory;
    private GuidedDecisionTreeDropContext dropContext = new GuidedDecisionTreeDropContext();
    private WiresTreeNodeConnector connector = null;
    private WiresBaseTreeNode uiRoot;
    private GuidedDecisionTree model;
    private GuidedDecisionTreeEditorPresenter presenter;
    private Group hint = null;
    private boolean isGettingStartedHintVisible = false;

    public GuidedDecisionTreeWidget() {
    }

    @Inject
    public GuidedDecisionTreeWidget(Event<ClearEvent> clearEvent, Event<ShapeSelectedEvent> shapeSelectedEvent, Event<ShapeAddedEvent> shapeAddedEvent, Event<ShapeDeletedEvent> shapeDeletedEvent, LayoutManager layoutManager, TypeNodeFactory typeNodeFactory, ConstraintNodeFactory constraintNodeFactory, ActionInsertNodeFactory actionInsertNodeFactory, ActionUpdateNodeFactory actionUpdateNodeFactory, ActionRetractNodeFactory actionRetractNodeFactory) {
        this.clearEvent = clearEvent;
        this.shapeSelectedEvent = shapeSelectedEvent;
        this.shapeAddedEvent = shapeAddedEvent;
        this.shapeDeletedEvent = shapeDeletedEvent;
        this.layoutManager = layoutManager;
        this.typeNodeFactory = typeNodeFactory;
        this.constraintNodeFactory = constraintNodeFactory;
        this.actionInsertNodeFactory = actionInsertNodeFactory;
        this.actionUpdateNodeFactory = actionUpdateNodeFactory;
        this.actionRetractNodeFactory = actionRetractNodeFactory;
    }

    public void init(GuidedDecisionTreeEditorPresenter presenter) {
        this.presenter = presenter;
    }

    public void selectShape(WiresBaseShape shape) {
        this.shapeSelectedEvent.fire((Object)new ShapeSelectedEvent(shape));
    }

    public void onShapeSelected(@Observes ShapeSelectedEvent event) {
        WiresBaseShape shape = event.getShape();
        super.selectShape(shape);
    }

    public void deselectShape(WiresBaseShape shape) {
        super.deselectShape(shape);
    }

    public void onDragPreviewHandler(@Observes ShapeDragPreviewEvent shapeDragPreviewEvent) {
        if (!(shapeDragPreviewEvent.getShape() instanceof BaseGuidedDecisionTreeShape)) {
            this.dropContext.setContext(null);
            return;
        }
        double cx = this.getX(shapeDragPreviewEvent.getX());
        double cy = this.getY(shapeDragPreviewEvent.getY());
        BaseGuidedDecisionTreeShape uiChild = (BaseGuidedDecisionTreeShape)shapeDragPreviewEvent.getShape();
        BaseGuidedDecisionTreeShape uiProspectiveParent = this.getParentNode(uiChild, cx, cy);
        if (uiProspectiveParent != null) {
            if (this.connector == null) {
                this.connector = new WiresTreeNodeConnector();
                this.canvasLayer.add((IPrimitive)this.connector);
                this.connector.moveToBottom();
            }
            this.connector.getPoints().get(0).set(uiProspectiveParent.getLocation());
            this.connector.getPoints().get(1).set(new Point2D(cx, cy));
        } else if (this.connector != null) {
            this.canvasLayer.remove((IPrimitive)this.connector);
            this.connector = null;
        }
        this.dropContext.setContext(uiProspectiveParent);
        this.canvasLayer.batch();
    }

    public void onDragCompleteHandler(@Observes ShapeDragCompleteEvent shapeDragCompleteEvent) {
        boolean addChildToParent;
        WiresBaseShape wiresShape = shapeDragCompleteEvent.getShape();
        if (this.connector != null) {
            this.canvasLayer.remove((IPrimitive)this.connector);
            this.canvasLayer.batch();
            this.connector = null;
        }
        if (wiresShape == null) {
            this.dropContext.setContext(null);
            return;
        }
        if (!(wiresShape instanceof BaseGuidedDecisionTreeShape)) {
            this.dropContext.setContext(null);
            return;
        }
        BaseGuidedDecisionTreeShape uiChild = (BaseGuidedDecisionTreeShape)wiresShape;
        double cx = this.getX(shapeDragCompleteEvent.getX());
        double cy = this.getY(shapeDragCompleteEvent.getY());
        if (cx < 0.0 || cy < 0.0) {
            this.dropContext.setContext(null);
            return;
        }
        int scrollWidth = this.getElement().getScrollWidth();
        int scrollHeight = this.getElement().getScrollHeight();
        if (cx > (double)scrollWidth || cy > (double)scrollHeight) {
            this.dropContext.setContext(null);
            return;
        }
        BaseGuidedDecisionTreeShape uiParent = this.dropContext.getContext();
        boolean addShape = this.getShapesInCanvas().size() == 0 && uiChild instanceof TypeShape || this.getShapesInCanvas().size() > 0 && uiParent != null;
        boolean bl = addChildToParent = uiParent != null;
        if (addShape) {
            uiChild.setX(cx);
            uiChild.setY(cy);
            if (addChildToParent) {
                uiParent.addChildNode(uiChild);
                uiParent.getModelNode().addChild(uiChild.getModelNode());
            } else if (uiChild instanceof TypeShape) {
                this.uiRoot = uiChild;
                this.model.setRoot((TypeNode)((TypeShape)uiChild).getModelNode());
            }
            this.addShape((WiresBaseShape)uiChild);
            this.shapeAddedEvent.fire((Object)new ShapeAddedEvent((WiresBaseShape)uiChild));
        }
    }

    private double getX(double xShapeEvent) {
        return xShapeEvent - (double)this.getAbsoluteLeft();
    }

    private double getY(double yShapeEvent) {
        return yShapeEvent - (double)this.getAbsoluteTop();
    }

    public void clear() {
        if (Window.confirm((String)GuidedDecisionTreeConstants.INSTANCE.confirmDeleteDecisionTree())) {
            super.clear();
            this.clearEvent.fire((Object)new ClearEvent());
            this.uiRoot = null;
        }
    }

    public void deleteShape(WiresBaseShape shape) {
        if (this.confirmShapeDeletion()) {
            if (this.uiRoot != null && this.uiRoot.equals((Object)shape)) {
                this.uiRoot = null;
                this.model.setRoot(null);
                this.shapeDeletedEvent.fire((Object)new ShapeDeletedEvent(shape));
            } else if (shape instanceof BaseGuidedDecisionTreeShape) {
                BaseGuidedDecisionTreeShape uiChild = (BaseGuidedDecisionTreeShape)shape;
                if (uiChild.getParentNode() instanceof BaseGuidedDecisionTreeShape) {
                    BaseGuidedDecisionTreeShape uiParent = (BaseGuidedDecisionTreeShape)uiChild.getParentNode();
                    uiParent.getModelNode().removeChild(uiChild.getModelNode());
                }
                this.shapeDeletedEvent.fire((Object)new ShapeDeletedEvent(shape));
                this.layout();
            }
        }
    }

    boolean confirmShapeDeletion() {
        return Window.confirm((String)GuidedDecisionTreeConstants.INSTANCE.confirmDeleteDecisionTreeNode());
    }

    public void forceDeleteShape(WiresBaseShape shape) {
        this.shapeDeletedEvent.fire((Object)new ShapeDeletedEvent(shape));
    }

    public void onShapeDeleted(@Observes ShapeDeletedEvent event) {
        super.deleteShape(event.getShape());
        if (this.getShapesInCanvas().isEmpty()) {
            this.showGettingStartedHint();
        }
    }

    public void addShape(WiresBaseShape shape) {
        super.addShape(shape);
        if (shape instanceof RequiresLayoutManager) {
            ((RequiresLayoutManager)shape).setLayoutManager(this.layoutManager);
        }
        if (shape instanceof BaseGuidedDecisionTreeShape) {
            ((BaseGuidedDecisionTreeShape)shape).setPresenter(this.presenter);
        }
        if (!this.getShapesInCanvas().isEmpty()) {
            this.hideGettingStartedHint();
        }
        this.layout();
    }

    public void setModel(GuidedDecisionTree model, boolean isReadOnly) {
        this.uiRoot = null;
        this.model = model;
        super.clear();
        this.clearEvent.fire((Object)new ClearEvent());
        TypeNode root = model.getRoot();
        if (root != null) {
            TypeShape uiRoot = this.typeNodeFactory.getShape(root, isReadOnly);
            this.uiRoot = uiRoot;
            this.processChildren((Node)root, uiRoot, isReadOnly);
            Map layout = this.layoutManager.getLayoutInformation((WiresBaseShape)uiRoot);
            Rectangle2D canvasBounds = WiresLayoutUtilities.alignLayoutInCanvas((Map)layout);
            for (Map.Entry e : layout.entrySet()) {
                Point2D destination = new Point2D(((Point2D)e.getValue()).getX(), ((Point2D)e.getValue()).getY());
                ((WiresBaseShape)e.getKey()).setLocation(destination);
            }
            WiresLayoutUtilities.resizeViewPort((Rectangle2D)canvasBounds, (Viewport)this.canvasLayer.getViewport());
        }
        if (this.shapesInCanvas.isEmpty()) {
            this.showGettingStartedHint();
        }
        this.canvasLayer.batch();
    }

    private void processChildren(Node node, WiresBaseTreeNode uiNode, boolean isReadOnly) {
        uiNode.setSelectionManager((SelectionManager)this);
        uiNode.setShapesManager((ShapesManager)this);
        uiNode.setLayoutManager(this.layoutManager);
        if (uiNode instanceof BaseGuidedDecisionTreeShape) {
            ((BaseGuidedDecisionTreeShape)uiNode).setPresenter(this.presenter);
        }
        this.canvasLayer.add((IPrimitive)uiNode);
        this.shapesInCanvas.add(uiNode);
        for (Node child : node) {
            BaseGuidedDecisionTreeShape uiChildNode = null;
            if (child instanceof TypeNode) {
                uiChildNode = this.typeNodeFactory.getShape((TypeNode)child, isReadOnly);
            } else if (child instanceof ConstraintNode) {
                uiChildNode = this.constraintNodeFactory.getShape((ConstraintNode)child, isReadOnly);
            } else if (child instanceof ActionInsertNode) {
                uiChildNode = this.actionInsertNodeFactory.getShape((ActionInsertNode)child, isReadOnly);
            } else if (child instanceof ActionUpdateNode) {
                uiChildNode = this.actionUpdateNodeFactory.getShape((ActionUpdateNode)child, isReadOnly);
            } else if (child instanceof ActionRetractNode) {
                uiChildNode = this.actionRetractNodeFactory.getShape((ActionRetractNode)child, isReadOnly);
            }
            if (uiChildNode == null) continue;
            uiNode.addChildNode((WiresBaseTreeNode)uiChildNode);
            this.processChildren(child, uiChildNode, isReadOnly);
        }
    }

    protected BaseGuidedDecisionTreeShape getParentNode(BaseGuidedDecisionTreeShape uiChild, double cx, double cy) {
        BaseGuidedDecisionTreeShape uiProspectiveParent = null;
        double finalDistance = Double.MAX_VALUE;
        for (WiresBaseShape ws : this.getShapesInCanvas()) {
            BaseGuidedDecisionTreeShape uiNode;
            if (!ws.isVisible() || !(ws instanceof BaseGuidedDecisionTreeShape) || !(uiNode = (BaseGuidedDecisionTreeShape)ws).acceptChildNode(uiChild) || uiNode.hasCollapsedChildren()) continue;
            double deltaX = cx - uiNode.getX();
            double deltaY = cy - uiNode.getY();
            double distance = Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
            if (!(finalDistance > distance)) continue;
            finalDistance = distance;
            uiProspectiveParent = uiNode;
        }
        if (finalDistance > 200.0) {
            uiProspectiveParent = null;
        }
        return uiProspectiveParent;
    }

    void layout() {
        final Map layout = this.layoutManager.getLayoutInformation((WiresBaseShape)this.uiRoot);
        final Rectangle2D canvasBounds = WiresLayoutUtilities.alignLayoutInCanvas((Map)layout);
        this.uiRoot.animate(AnimationTweener.EASE_OUT, new AnimationProperties(), 250.0, new IAnimationCallback(){
            private final Map<WiresBaseShape, Pair<Point2D, Point2D>> transformations = new HashMap<WiresBaseShape, Pair<Point2D, Point2D>>();

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                this.transformations.clear();
                for (Map.Entry e : layout.entrySet()) {
                    Point2D origin = ((WiresBaseShape)e.getKey()).getLocation();
                    Point2D destination = new Point2D(((Point2D)e.getValue()).getX(), ((Point2D)e.getValue()).getY());
                    this.transformations.put((WiresBaseShape)e.getKey(), (Pair<Point2D, Point2D>)new Pair((Object)origin, (Object)destination));
                }
                WiresLayoutUtilities.resizeViewPort((Rectangle2D)canvasBounds, (Viewport)GuidedDecisionTreeWidget.this.canvasLayer.getViewport());
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = iAnimation.getPercent() > 1.0 ? 1.0 : iAnimation.getPercent();
                for (Map.Entry<WiresBaseShape, Pair<Point2D, Point2D>> e : this.transformations.entrySet()) {
                    Point2D descendantOrigin = (Point2D)e.getValue().getK1();
                    Point2D descendantTarget = (Point2D)e.getValue().getK2();
                    double dx = (descendantTarget.getX() - descendantOrigin.getX()) * pct;
                    double dy = (descendantTarget.getY() - descendantOrigin.getY()) * pct;
                    e.getKey().setX(descendantOrigin.getX() + dx);
                    e.getKey().setY(descendantOrigin.getY() + dy);
                }
                GuidedDecisionTreeWidget.this.uiRoot.getLayer().batch();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
            }
        });
        this.canvasLayer.batch();
    }

    private void showGettingStartedHint() {
        if (this.isGettingStartedHintVisible) {
            return;
        }
        if (this.hint == null) {
            this.hint = new Group();
            Rectangle hintRectangle = new Rectangle(600.0, 225.0, 15.0);
            hintRectangle.setStrokeWidth(2.0);
            hintRectangle.setStrokeColor("#6495ED");
            hintRectangle.setFillColor("#AFEEEE");
            hintRectangle.setAlpha(0.75);
            Text hintText = new Text(GuidedDecisionTreeConstants.INSTANCE.gettingStartedHint(), "oblique normal", 18.0);
            hintText.setTextAlign(TextAlign.CENTER);
            hintText.setTextBaseLine(TextBaseLine.MIDDLE);
            hintText.setFillColor("#6495ED");
            hintText.setX(hintRectangle.getWidth() / 2.0);
            hintText.setY(hintRectangle.getHeight() / 2.0);
            this.hint.setX(((double)this.canvasLayer.getWidth() - hintRectangle.getWidth()) / 2.0);
            this.hint.setY((double)(this.canvasLayer.getHeight() / 3) - hintRectangle.getHeight() / 2.0);
            this.hint.add((IPrimitive)hintRectangle);
            this.hint.add((IPrimitive)hintText);
        }
        this.hint.animate(AnimationTweener.LINEAR, new AnimationProperties(), 250.0, new IAnimationCallback(){

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                GuidedDecisionTreeWidget.this.hint.setAlpha(0.0);
                GuidedDecisionTreeWidget.this.canvasLayer.add((IPrimitive)GuidedDecisionTreeWidget.this.hint);
                GuidedDecisionTreeWidget.this.isGettingStartedHintVisible = true;
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = iAnimation.getPercent() > 1.0 ? 1.0 : iAnimation.getPercent();
                GuidedDecisionTreeWidget.this.hint.setAlpha(pct);
                GuidedDecisionTreeWidget.this.hint.getLayer().batch();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
            }
        });
    }

    private void hideGettingStartedHint() {
        if (!this.isGettingStartedHintVisible) {
            return;
        }
        this.hint.animate(AnimationTweener.LINEAR, new AnimationProperties(), 250.0, new IAnimationCallback(){

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = iAnimation.getPercent() > 1.0 ? 1.0 : iAnimation.getPercent();
                GuidedDecisionTreeWidget.this.hint.setAlpha(1.0 - pct);
                GuidedDecisionTreeWidget.this.hint.getLayer().batch();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                GuidedDecisionTreeWidget.this.canvasLayer.remove((IPrimitive)GuidedDecisionTreeWidget.this.hint);
                GuidedDecisionTreeWidget.this.isGettingStartedHintVisible = false;
            }
        });
    }

    void setUiRoot(WiresBaseTreeNode uiRoot) {
        this.uiRoot = uiRoot;
    }

    void setModel(GuidedDecisionTree model) {
        this.model = model;
    }
}

