/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.client.widget;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.ConstraintNodeImpl;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.TypeNodeImpl;
import org.drools.workbench.screens.guided.dtree.client.editor.GuidedDecisionTreeEditorPresenter;
import org.drools.workbench.screens.guided.dtree.client.widget.GuidedDecisionTreeWidget;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ActionInsertNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ActionRetractNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ActionUpdateNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.ConstraintNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.factories.TypeNodeFactory;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.ConstraintShape;
import org.drools.workbench.screens.guided.dtree.client.widget.shapes.TypeShape;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.api.events.ClearEvent;
import org.uberfire.ext.wires.core.api.events.ShapeAddedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDeletedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeSelectedEvent;
import org.uberfire.ext.wires.core.api.layout.LayoutManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.trees.client.shapes.WiresBaseTreeNode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTreeWidgetTest {
    @Mock
    private EventSourceMock<ClearEvent> clearEvent;
    @Mock
    private EventSourceMock<ShapeSelectedEvent> shapeSelectedEvent;
    @Mock
    private EventSourceMock<ShapeAddedEvent> shapeAddedEvent;
    @Mock
    private EventSourceMock<ShapeDeletedEvent> shapeDeletedEvent;
    @Mock
    private LayoutManager layoutManager;
    @Mock
    private TypeNodeFactory typeNodeFactory;
    @Mock
    private ConstraintNodeFactory constraintNodeFactory;
    @Mock
    private ActionInsertNodeFactory actionInsertNodeFactory;
    @Mock
    private ActionUpdateNodeFactory actionUpdateNodeFactory;
    @Mock
    private ActionRetractNodeFactory actionRetractNodeFactory;
    @Mock
    private GuidedDecisionTreeEditorPresenter presenter;
    @Captor
    private ArgumentCaptor<ShapeDeletedEvent> shapeDeletedEventCaptor;
    private TypeShape uiRootShape;
    private TypeNode uiRootNode = new TypeNodeImpl("Person");
    private ConstraintShape uiChildShape;
    private ConstraintNodeImpl uiChildNode = new ConstraintNodeImpl("Person", "age");
    private GuidedDecisionTreeWidget widget;
    private GuidedDecisionTree uiModel;

    @Before
    public void setup() {
        ApplicationPreferences.setUp(Collections.singletonMap("drools.dateformat", "dd/mm/yyyy"));
        this.widget = (GuidedDecisionTreeWidget)Mockito.spy((Object)new GuidedDecisionTreeWidget(this.clearEvent, this.shapeSelectedEvent, this.shapeAddedEvent, this.shapeDeletedEvent, this.layoutManager, this.typeNodeFactory, this.constraintNodeFactory, this.actionInsertNodeFactory, this.actionUpdateNodeFactory, this.actionRetractNodeFactory));
        this.uiRootShape = (TypeShape)Mockito.mock(TypeShape.class);
        this.uiChildShape = (ConstraintShape)Mockito.mock(ConstraintShape.class);
        ((TypeShape)Mockito.doReturn((Object)this.uiRootNode).when((Object)this.uiRootShape)).getModelNode();
        ((ConstraintShape)Mockito.doReturn((Object)this.uiChildNode).when((Object)this.uiChildShape)).getModelNode();
        ((ConstraintShape)Mockito.doReturn((Object)this.uiRootShape).when((Object)this.uiChildShape)).getParentNode();
        this.widget.init(this.presenter);
        this.widget.init();
        this.uiModel = new GuidedDecisionTree();
        this.uiModel.setRoot(this.uiRootNode);
        this.widget.setModel(this.uiModel);
        this.widget.setUiRoot((WiresBaseTreeNode)this.uiRootShape);
        this.uiRootNode.addChild((Node)this.uiChildNode);
    }

    @Test
    public void testDeleteShapeNotConfirmed() {
        ((GuidedDecisionTreeWidget)Mockito.doReturn((Object)false).when((Object)this.widget)).confirmShapeDeletion();
        TypeShape shapeToDelete = this.uiRootShape;
        this.widget.deleteShape((WiresBaseShape)shapeToDelete);
        ((EventSourceMock)Mockito.verify(this.shapeDeletedEvent, (VerificationMode)Mockito.never())).fire((Object)((ShapeDeletedEvent)Matchers.any(ShapeDeletedEvent.class)));
        ((GuidedDecisionTreeWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).layout();
        Assert.assertEquals((Object)this.uiRootNode, (Object)this.uiModel.getRoot());
    }

    @Test
    public void testDeleteShapeConfirmedRootNode() {
        ((GuidedDecisionTreeWidget)Mockito.doReturn((Object)true).when((Object)this.widget)).confirmShapeDeletion();
        TypeShape shapeToDelete = this.uiRootShape;
        this.widget.deleteShape((WiresBaseShape)shapeToDelete);
        ((EventSourceMock)Mockito.verify(this.shapeDeletedEvent)).fire((Object)((ShapeDeletedEvent)this.shapeDeletedEventCaptor.capture()));
        Assert.assertEquals((Object)shapeToDelete, (Object)((ShapeDeletedEvent)this.shapeDeletedEventCaptor.getValue()).getShape());
        ((GuidedDecisionTreeWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).layout();
        Assert.assertNull((Object)this.uiModel.getRoot());
    }

    @Test
    public void testDeleteShapeConfirmedNonRootNode() {
        ((GuidedDecisionTreeWidget)Mockito.doReturn((Object)true).when((Object)this.widget)).confirmShapeDeletion();
        ConstraintShape shapeToDelete = this.uiChildShape;
        this.widget.deleteShape((WiresBaseShape)shapeToDelete);
        ((EventSourceMock)Mockito.verify(this.shapeDeletedEvent)).fire((Object)((ShapeDeletedEvent)this.shapeDeletedEventCaptor.capture()));
        Assert.assertEquals((Object)shapeToDelete, (Object)((ShapeDeletedEvent)this.shapeDeletedEventCaptor.getValue()).getShape());
        ((GuidedDecisionTreeWidget)Mockito.verify((Object)this.widget)).layout();
        Assert.assertFalse((boolean)this.uiRootNode.getChildren().contains(this.uiChildNode));
    }
}

