/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromEntryPointFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.FactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.FreeFormLineWidget;
import org.drools.workbench.screens.guided.rule.client.widget.FromAccumulateCompositeFactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.FromCompositeFactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.FromEntryPointFactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class FromCollectCompositeFactPatternWidget
extends FromCompositeFactPatternWidget {
    private Map<String, String> extraLeftSidePatternFactTypes = null;

    public FromCollectCompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, FromCollectCompositeFactPattern pattern) {
        super(modeller, eventBus, (FromCompositeFactPattern)pattern);
    }

    public FromCollectCompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, FromCollectCompositeFactPattern pattern, Boolean readOnly) {
        super(modeller, eventBus, (FromCompositeFactPattern)pattern, readOnly);
    }

    private void initExtraLeftSidePatternFactTypes() {
        this.extraLeftSidePatternFactTypes = new HashMap<String, String>();
        if (this.modelImportsClass("java.util.Collection")) {
            this.extraLeftSidePatternFactTypes.put("Collection", "Collection");
        }
        if (this.modelImportsClass("java.util.List")) {
            this.extraLeftSidePatternFactTypes.put("List", "List");
        }
        if (this.modelImportsClass("java.util.Set")) {
            this.extraLeftSidePatternFactTypes.put("Set", "Set");
        }
    }

    private boolean modelImportsClass(String fullyQualifiedClassName) {
        for (Import i : this.modeller.getModel().getImports().getImports()) {
            if (!i.getType().equals(fullyQualifiedClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Widget getCompositeLabel() {
        ClickHandler leftPatternclick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget w = (Widget)event.getSource();
                FromCollectCompositeFactPatternWidget.this.showFactTypeSelector(w);
            }
        };
        ClickHandler rightPatternclick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget w = (Widget)event.getSource();
                FromCollectCompositeFactPatternWidget.this.showRightPatternSelector(w);
            }
        };
        String lbl = "<div class='form-field'>" + HumanReadable.getCEDisplayName((String)"from collect") + "</div>";
        FlexTable panel = new FlexTable();
        int r = 0;
        if (this.pattern.getFactPattern() == null) {
            panel.setWidget(r++, 0, (Widget)new ClickableLabel("<br> <font color='red'>" + GuidedRuleEditorResources.CONSTANTS.clickToAddPatterns() + "</font>", leftPatternclick, !this.readOnly));
        }
        panel.setWidget(r++, 0, (Widget)new HTML(lbl));
        if (this.getFromCollectPattern().getRightPattern() == null) {
            panel.setWidget(r++, 0, (Widget)new ClickableLabel("<br> <font color='red'>" + GuidedRuleEditorResources.CONSTANTS.clickToAddPatterns() + "</font>", rightPatternclick, !this.readOnly));
        } else {
            IPattern rPattern = this.getFromCollectPattern().getRightPattern();
            RuleModellerWidget patternWidget = null;
            if (rPattern instanceof FactPattern) {
                patternWidget = new FactPatternWidget(this.getModeller(), this.getEventBus(), rPattern, true, true, this.readOnly);
            } else if (rPattern instanceof FromAccumulateCompositeFactPattern) {
                patternWidget = new FromAccumulateCompositeFactPatternWidget(this.getModeller(), this.getEventBus(), (FromAccumulateCompositeFactPattern)rPattern, (Boolean)this.readOnly);
            } else if (rPattern instanceof FromCollectCompositeFactPattern) {
                patternWidget = new FromCollectCompositeFactPatternWidget(this.getModeller(), this.getEventBus(), (FromCollectCompositeFactPattern)rPattern, (Boolean)this.readOnly);
            } else if (rPattern instanceof FromEntryPointFactPattern) {
                patternWidget = new FromEntryPointFactPatternWidget(this.getModeller(), this.getEventBus(), (FromEntryPointFactPattern)rPattern, (Boolean)this.readOnly);
            } else if (rPattern instanceof FromCompositeFactPattern) {
                patternWidget = new FromCompositeFactPatternWidget(this.getModeller(), this.getEventBus(), (FromCompositeFactPattern)rPattern, this.readOnly);
            } else if (rPattern instanceof FreeFormLine) {
                patternWidget = new FreeFormLineWidget(this.getModeller(), this.getEventBus(), (FreeFormLine)rPattern, this.readOnly);
            } else {
                throw new IllegalArgumentException("Unsupported pattern " + rPattern + " for right side of FROM COLLECT");
            }
            patternWidget.addOnModifiedCommand(new Command(){

                public void execute() {
                    FromCollectCompositeFactPatternWidget.this.setModified(true);
                }
            });
            panel.setWidget(r++, 0, this.addRemoveButton((Widget)patternWidget, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisBlockOfData())) {
                        FromCollectCompositeFactPatternWidget.this.setModified(true);
                        FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern(null);
                        FromCollectCompositeFactPatternWidget.this.getModeller().refreshWidget();
                    }
                }
            }));
        }
        return panel;
    }

    @Override
    protected void showFactTypeSelector(Widget w) {
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorResources.CONSTANTS.NewFactPattern());
        popup.setTitle(GuidedRuleEditorResources.CONSTANTS.NewFactPattern());
        final ListBox box = new ListBox();
        box.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        for (Map.Entry<String, String> entry : this.getExtraLeftSidePatternFactTypes().entrySet()) {
            box.addItem(entry.getKey(), entry.getValue());
        }
        box.setSelectedIndex(0);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FromCollectCompositeFactPatternWidget.this.pattern.setFactPattern(new FactPattern(box.getValue(box.getSelectedIndex())));
                FromCollectCompositeFactPatternWidget.this.setModified(true);
                FromCollectCompositeFactPatternWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.chooseFactType(), (IsWidget)box);
        popup.show();
    }

    protected void showRightPatternSelector(Widget w) {
        final ListBox box = new ListBox();
        AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        String[] facts = oracle.getFactTypes();
        box.addItem(GuidedRuleEditorResources.CONSTANTS.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorResources.CONSTANTS.NewFactPattern());
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.chooseFactType(), (IsWidget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern((IPattern)new FactPattern(box.getItemText(box.getSelectedIndex())));
                FromCollectCompositeFactPatternWidget.this.setModified(true);
                FromCollectCompositeFactPatternWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        final Button freeFormDRLBtn = new Button(GuidedRuleEditorResources.CONSTANTS.FreeFormDrl());
        final Button fromBtn = new Button(HumanReadableConstants.INSTANCE.From());
        final Button fromAccumulateBtn = new Button(HumanReadableConstants.INSTANCE.FromAccumulate());
        final Button fromCollectBtn = new Button(HumanReadableConstants.INSTANCE.FromCollect());
        final Button fromEntryPointBtn = new Button(HumanReadableConstants.INSTANCE.FromEntryPoint());
        ClickHandler btnsClickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget sender = (Widget)event.getSource();
                if (sender == fromBtn) {
                    FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern((IPattern)new FromCompositeFactPattern());
                } else if (sender == fromAccumulateBtn) {
                    FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern((IPattern)new FromAccumulateCompositeFactPattern());
                } else if (sender == fromCollectBtn) {
                    FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern((IPattern)new FromCollectCompositeFactPattern());
                } else if (sender == freeFormDRLBtn) {
                    FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern((IPattern)new FreeFormLine());
                } else if (sender == fromEntryPointBtn) {
                    FromCollectCompositeFactPatternWidget.this.getFromCollectPattern().setRightPattern((IPattern)new FromEntryPointFactPattern());
                } else {
                    throw new IllegalArgumentException("Unknown sender: " + sender);
                }
                FromCollectCompositeFactPatternWidget.this.setModified(true);
                FromCollectCompositeFactPatternWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        };
        freeFormDRLBtn.addClickHandler(btnsClickHandler);
        fromBtn.addClickHandler(btnsClickHandler);
        fromAccumulateBtn.addClickHandler(btnsClickHandler);
        fromCollectBtn.addClickHandler(btnsClickHandler);
        fromEntryPointBtn.addClickHandler(btnsClickHandler);
        popup.addAttribute("", (IsWidget)freeFormDRLBtn);
        popup.addAttribute("", (IsWidget)fromBtn);
        popup.addAttribute("", (IsWidget)fromAccumulateBtn);
        popup.addAttribute("", (IsWidget)fromCollectBtn);
        popup.addAttribute("", (IsWidget)fromEntryPointBtn);
        popup.show();
    }

    private FromCollectCompositeFactPattern getFromCollectPattern() {
        return (FromCollectCompositeFactPattern)this.pattern;
    }

    @Override
    protected void calculateReadOnly() {
        if (this.pattern.getFactPattern() != null) {
            String factType = this.pattern.getFactPattern().getFactType();
            this.isFactTypeKnown = this.getExtraLeftSidePatternFactTypes().values().contains(factType) ? true : this.getModeller().getDataModelOracle().isFactTypeRecognized(factType);
            if (this.pattern.getFactPattern() != null) {
                this.readOnly = !this.getExtraLeftSidePatternFactTypes().containsValue(this.pattern.getFactPattern().getFactType()) && !this.getModeller().getDataModelOracle().isFactTypeRecognized(this.pattern.getFactPattern().getFactType());
            }
        }
    }

    private Map<String, String> getExtraLeftSidePatternFactTypes() {
        if (this.extraLeftSidePatternFactTypes == null) {
            this.initExtraLeftSidePatternFactTypes();
        }
        return this.extraLeftSidePatternFactTypes;
    }
}

