/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleAttributeWidget;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.widgets.common.client.common.DirtyableHorizontalPane;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class AttributeSelectorPopup
extends FormStylePopup {
    private final TextBox box = new TextBox();

    public AttributeSelectorPopup(RuleModel model, boolean lockLHS, boolean lockRHS, Command refresh) {
        super(AttributeSelectorPopup.getImage(), GuidedRuleEditorResources.CONSTANTS.AddAnOptionToTheRule());
        this.setTextBox(model, refresh);
        this.setListBox(model, refresh);
        this.setFreezePanel(model, lockLHS, lockRHS, refresh);
    }

    private static Image getImage() {
        Image image = new Image(GuidedRuleEditorResources.INSTANCE.images().config());
        image.setAltText(GuidedRuleEditorResources.CONSTANTS.Config());
        return image;
    }

    private void setTextBox(RuleModel model, Command refresh) {
        ((InputElement)this.box.getElement().cast()).setSize(15);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)this.box);
        horiz.add((Widget)this.getAddButton(model, refresh, this.box));
        this.addAttribute(GuidedRuleEditorResources.CONSTANTS.Metadata3(), (IsWidget)horiz);
    }

    private void setListBox(final RuleModel model, final Command refresh) {
        final ListBox list = RuleAttributeWidget.getAttributeList();
        block0: for (RuleAttribute at : model.attributes) {
            for (int iItem = 0; iItem < list.getItemCount(); ++iItem) {
                if (!list.getItemText(iItem).equals(at.getAttributeName())) continue;
                list.removeItem(iItem);
                continue block0;
            }
        }
        list.setSelectedIndex(0);
        list.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String attr = list.getItemText(list.getSelectedIndex());
                if (attr.equals("freeze_conditions") || attr.equals("freeze_actions")) {
                    model.addMetadata(new RuleMetadata(attr, "true"));
                } else {
                    model.addAttribute(new RuleAttribute(attr, ""));
                }
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        this.addAttribute(GuidedRuleEditorResources.CONSTANTS.Attribute1(), (IsWidget)list);
    }

    private void setFreezePanel(final RuleModel model, boolean lockLHS, boolean lockRHS, final Command refresh) {
        Button freezeConditions = new Button(GuidedRuleEditorResources.CONSTANTS.Conditions());
        freezeConditions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.addMetadata(new RuleMetadata("freeze_conditions", "true"));
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        Button freezeActions = new Button(GuidedRuleEditorResources.CONSTANTS.Actions());
        freezeActions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.addMetadata(new RuleMetadata("freeze_actions", "true"));
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        HorizontalPanel hz = new HorizontalPanel();
        if (!lockLHS) {
            hz.add((Widget)freezeConditions);
        }
        if (!lockRHS) {
            hz.add((Widget)freezeActions);
        }
        hz.add((IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.FrozenAreas(), GuidedRuleEditorResources.CONSTANTS.FrozenExplanation()));
        if (hz.getWidgetCount() > 1) {
            this.addAttribute(GuidedRuleEditorResources.CONSTANTS.FreezeAreasForEditing(), (IsWidget)hz);
        }
    }

    private Image getAddButton(final RuleModel model, final Command refresh, final TextBox box) {
        Image addbutton = GuidedRuleEditorImages508.INSTANCE.NewItem();
        addbutton.setAltText(GuidedRuleEditorResources.CONSTANTS.AddMetadataToTheRule());
        addbutton.setTitle(GuidedRuleEditorResources.CONSTANTS.AddMetadataToTheRule());
        addbutton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String metaData = box.getText().trim();
                if (metaData.isEmpty()) {
                    Window.alert((String)GuidedRuleEditorResources.CONSTANTS.MetadataNameEmpty());
                    return;
                }
                boolean isUnique = true;
                for (RuleMetadata rm : model.metadataList) {
                    if (!rm.getAttributeName().equals(metaData)) continue;
                    isUnique = false;
                    break;
                }
                if (!isUnique) {
                    Window.alert((String)GuidedRuleEditorResources.CONSTANTS.MetadataNotUnique0(metaData));
                    return;
                }
                model.addMetadata(new RuleMetadata(box.getText(), ""));
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        return addbutton;
    }
}

