/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionInsertLogicalFact;
import org.drools.workbench.screens.guided.rule.client.editor.ActionValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class ActionInsertFactWidget
extends RuleModellerWidget {
    private final FlexTable layout;
    private final ActionInsertFact model;
    private ModelField[] fieldCompletions;
    private final String factType;
    private boolean readOnly;
    private boolean isFactTypeKnown;
    private final Map<ActionFieldValue, ActionValueEditor> actionValueEditors = new HashMap<ActionFieldValue, ActionValueEditor>();

    public ActionInsertFactWidget(RuleModeller mod, EventBus eventBus, ActionInsertFact set, Boolean readOnly) {
        super(mod, eventBus);
        this.model = set;
        this.layout = new FlexTable();
        this.factType = set.getFactType();
        AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        oracle.getFieldCompletions(set.getFactType(), FieldAccessorsAndMutators.MUTATOR, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                ActionInsertFactWidget.access$002(ActionInsertFactWidget.this, fields);
            }
        });
        this.isFactTypeKnown = oracle.isFactTypeRecognized(set.getFactType());
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getAssertLabel());
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        FlexTable inner = new FlexTable();
        int col = 0;
        for (int i = 0; i < this.model.getFieldValues().length; ++i) {
            ActionFieldValue val = this.model.getFieldValues()[i];
            inner.setWidget(i, 0 + col, this.fieldSelector(val));
            inner.setWidget(i, 1 + col, this.valueEditor(val));
            final int idx = i;
            Image remove = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
            remove.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisItem())) {
                        ActionInsertFactWidget.this.model.removeField(idx);
                        ActionInsertFactWidget.this.setModified(true);
                        ActionInsertFactWidget.this.getModeller().refreshWidget();
                        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(ActionInsertFactWidget.this.getModeller().getModel());
                        ActionInsertFactWidget.this.getEventBus().fireEventFromSource((GwtEvent)tvce, (Object)ActionInsertFactWidget.this.getModeller().getModel());
                    }
                }
            });
            if (this.readOnly) continue;
            inner.setWidget(i, 2 + col, (Widget)remove);
        }
        this.layout.setWidget(1, 1, (Widget)inner);
    }

    private Widget valueEditor(final ActionFieldValue val) {
        ActionValueEditor actionValueEditor = new ActionValueEditor(this.factType, val, this.model.getFieldValues(), this.getModeller(), this.getEventBus(), val.getType(), this.readOnly);
        actionValueEditor.setOnChangeCommand(new Command(){

            public void execute() {
                ActionInsertFactWidget.this.refreshActionValueEditorsDropDownData(val);
                ActionInsertFactWidget.this.setModified(true);
            }
        });
        this.actionValueEditors.put(val, actionValueEditor);
        return actionValueEditor;
    }

    private void refreshActionValueEditorsDropDownData(ActionFieldValue modifiedField) {
        for (Map.Entry<ActionFieldValue, ActionValueEditor> e : this.actionValueEditors.entrySet()) {
            ActionFieldValue afv = e.getKey();
            if (afv.getNature() != 1 && afv.getNature() != 4 || afv.equals((Object)modifiedField)) continue;
            e.getValue().refresh();
        }
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.getField());
    }

    private Widget getAssertLabel() {
        String lbl;
        ClickHandler cl = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Widget w = (Widget)event.getSource();
                ActionInsertFactWidget.this.showAddFieldPopup(w);
            }
        };
        String assertType = "assert";
        if (this.model instanceof ActionInsertLogicalFact) {
            assertType = "assertLogical";
        }
        String string = lbl = !this.model.isBound() ? HumanReadable.getActionDisplayName((String)assertType) + " <b>" + this.model.getFactType() + "</b>" : HumanReadable.getActionDisplayName((String)assertType) + " <b>" + this.model.getFactType() + "</b>" + " <b>[" + this.model.getBoundName() + "]</b>";
        if (this.model.getFieldValues() != null && this.model.getFieldValues().length > 0) {
            lbl = lbl + ":";
        }
        return new ClickableLabel(lbl, cl, !this.readOnly);
    }

    protected void showAddFieldPopup(Widget w) {
        final AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.AddAField());
        final ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i].getName());
        }
        box.setSelectedIndex(0);
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.AddField(), (IsWidget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fieldName = box.getItemText(box.getSelectedIndex());
                String fieldType = oracle.getFieldType(ActionInsertFactWidget.this.model.getFactType(), fieldName);
                ActionInsertFactWidget.this.model.addFieldValue(new ActionFieldValue(fieldName, "", fieldType));
                ActionInsertFactWidget.this.setModified(true);
                ActionInsertFactWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        HorizontalPanel vn = new HorizontalPanel();
        final TextBox varName = new TextBox();
        if (this.model.getBoundName() != null) {
            varName.setText(this.model.getBoundName());
        }
        Button ok = new Button(HumanReadableConstants.INSTANCE.Set());
        vn.add((Widget)varName);
        vn.add((Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String var = varName.getText();
                if (ActionInsertFactWidget.this.getModeller().isVariableNameUsed(var) && (ActionInsertFactWidget.this.model.getBoundName() != null && !ActionInsertFactWidget.this.model.getBoundName().equals(var) || ActionInsertFactWidget.this.model.getBoundName() == null)) {
                    Window.alert((String)GuidedRuleEditorResources.CONSTANTS.TheVariableName0IsAlreadyTaken(var));
                    return;
                }
                ActionInsertFactWidget.this.model.setBoundName(var);
                ActionInsertFactWidget.this.setModified(true);
                ActionInsertFactWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.BoundVariable(), (IsWidget)vn);
        popup.show();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    static /* synthetic */ ModelField[] access$002(ActionInsertFactWidget x0, ModelField[] x1) {
        x0.fieldCompletions = x1;
        return x1;
    }
}

