/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.AddConstraintButton;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.guvnor.common.services.workingset.client.WorkingSetManager;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.LiteralTextBox;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={AddConstraintButton.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class ConstraintValueEditorTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private SingleFieldConstraint constraint;
    @Mock
    private WorkingSetManager wsManager;
    @GwtMock
    private RuleModeller ruleModeller;

    @Before
    public void setup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("drools.dateformat", "dd MMM yyyy");
        ApplicationPreferences.setUp(map);
        Mockito.when((Object)this.ruleModeller.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.getFieldType(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)this.constraint.getConstraintValueType()).thenReturn((Object)1);
    }

    @Test
    public void correctWidgetForStringField() {
        ConstraintValueEditor editor = this.createEditor();
        Assert.assertTrue((boolean)(editor.getConstraintWidget() instanceof LiteralTextBox));
    }

    @Test
    public void correctWidgetForStringFieldValueInList() {
        Mockito.when((Object)this.constraint.getOperator()).thenReturn((Object)"in");
        ConstraintValueEditor editor = this.createEditor();
        Assert.assertTrue((boolean)(editor.getConstraintWidget() instanceof LiteralTextBox));
    }

    @Test
    public void correctWidgetForStringFieldValueNotInList() {
        Mockito.when((Object)this.constraint.getOperator()).thenReturn((Object)"not in");
        ConstraintValueEditor editor = this.createEditor();
        Assert.assertTrue((boolean)(editor.getConstraintWidget() instanceof LiteralTextBox));
    }

    private ConstraintValueEditor createEditor() {
        return new ConstraintValueEditor((BaseSingleFieldConstraint)this.constraint, (CompositeFieldConstraint)Mockito.mock(CompositeFieldConstraint.class), this.ruleModeller, (EventBus)Mockito.mock(EventBus.class), false){

            void setBoxSize(TextBox box) {
            }

            Widget wrap(Widget widget) {
                return widget;
            }

            WorkingSetManager getWorkingSetManager() {
                return ConstraintValueEditorTest.this.wsManager;
            }
        };
    }
}

