/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.user.client.Element;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.guided.rule.client.editor.AttributeSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@WithClassesToStub(value={GuidedRuleEditorImages508.class, Heading.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class AttributeSelectorPopupTest {
    static String[] attributes = new String[]{"attr1", "attr2", "attr3", "attr4"};
    static String[] duplicates = new String[]{"attr2", "attr3"};
    static String metadataName = "mockMetadata";
    @GwtMock
    TextBox boxMock;
    @GwtMock
    ListBox listMock;
    List<String> listMockAttributes;
    MockAttributeSelectorPopup popup;

    @Before
    public void setUp() {
        this.listMockAttributes = new ArrayList<String>();
        this.popup = (MockAttributeSelectorPopup)((Object)Mockito.spy((Object)((Object)new MockAttributeSelectorPopup())));
        Mockito.when((Object)this.boxMock.getElement()).thenReturn(Mockito.mock(Element.class));
        Mockito.when((Object)this.boxMock.getText()).thenReturn((Object)metadataName);
        Mockito.when((Object)this.listMock.getItemCount()).thenAnswer(invocation -> this.listMockAttributes.size());
        Mockito.when((Object)this.listMock.getItemText(Matchers.anyInt())).thenAnswer(invocation -> this.listMockAttributes.get((Integer)invocation.getArguments()[0]));
        ((ListBox)Mockito.doAnswer(invocation -> {
            this.listMockAttributes.add((String)invocation.getArguments()[0]);
            return null;
        }).when((Object)this.listMock)).addItem(Matchers.anyString());
        ((ListBox)Mockito.doAnswer(invocation -> {
            this.listMockAttributes.remove((Integer)invocation.getArguments()[0]);
            return null;
        }).when((Object)this.listMock)).removeItem(Matchers.anyInt());
        this.popup.initialize(this.boxMock, this.listMock);
    }

    @Test
    public void alreadyUsedAttributesRemoved() {
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup)))).getAttributes();
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup)))).getReservedAttributes();
        ((ListBox)Mockito.verify((Object)this.popup.list, (VerificationMode)Mockito.times((int)4))).addItem(Matchers.anyString());
        ((ListBox)Mockito.verify((Object)this.popup.list, (VerificationMode)Mockito.times((int)2))).removeItem(1);
    }

    @Test
    public void alreadyUsedMetadataNotAllowed() {
        this.popup.getMetadataHandler().onClick(null);
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup)))).isMetadataUnique(metadataName);
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup)))).metadataNotUniqueMessage(metadataName);
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup), (VerificationMode)Mockito.never()))).handleMetadataAddition(Matchers.anyString());
    }

    @Test
    public void emptyMetadataNotAllowed() {
        Mockito.when((Object)this.boxMock.getText()).thenReturn((Object)"");
        this.popup.getMetadataHandler().onClick(null);
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup), (VerificationMode)Mockito.never()))).handleMetadataAddition(Matchers.anyString());
    }

    @Test
    public void whitespaceMetadataNotAllowed() {
        Mockito.when((Object)this.boxMock.getText()).thenReturn((Object)" \n\t ");
        this.popup.getMetadataHandler().onClick(null);
        ((MockAttributeSelectorPopup)((Object)Mockito.verify((Object)((Object)this.popup), (VerificationMode)Mockito.never()))).handleMetadataAddition(Matchers.anyString());
    }

    private static class MockAttributeSelectorPopup
    extends AttributeSelectorPopup {
        private MockAttributeSelectorPopup() {
        }

        protected String[] getAttributes() {
            return attributes;
        }

        protected String[] getReservedAttributes() {
            return duplicates;
        }

        protected void handleAttributeAddition(String attributeName) {
        }

        protected boolean isMetadataUnique(String metadataName) {
            return false;
        }

        protected String metadataNotUniqueMessage(String metadataName) {
            return "mock message";
        }

        protected void handleMetadataAddition(String metadataName) {
        }
    }
}

