/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import com.google.gwtmockito.fakes.FakeProvider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.oracle.DSLConditionSentence;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerConditionSelectorPopup;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.validation.client.dynamic.DynamicValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.soup.project.datamodel.oracle.ExtensionKind;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.builder.packages.PackageDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.MockInstanceImpl;

@WithClassesToStub(value={Text.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class RuleModellerConditionSelectorPopupTest {
    private static final String DSL_SENTENCE_CHOICE_KEY = "dslSentence";
    private static final String DSL_SENTENCE_CHOICE_VALUE = "DSLdslSentence";
    @Mock
    private SyncBeanDef syncBeanDef;
    @Mock
    private SyncBeanManager syncBeanManager;
    @Spy
    @InjectMocks
    private AsyncPackageDataModelOracleFactory asyncPackageDataModelOracleFactory;
    @Mock
    private IncrementalDataModelService incrementalDataModelService;
    private Caller<IncrementalDataModelService> incrementalDataModelServiceCaller;
    private Instance<DynamicValidator> validatorInstance;
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Path resourcePath;
    @Mock
    private ListBox choices;
    @Mock
    private RuleModel model;
    @Mock
    private RuleModeller ruleModeller;
    private PackageDataModelOracleBaselinePayload dataModelPayload;
    private PackageDataModelOracle dataModel;
    @Captor
    private ArgumentCaptor<String> keyCaptor;
    @Captor
    private ArgumentCaptor<String> valueCaptor;
    @Mock
    private DSLSentence dslSentence;

    @Before
    public void setUp() throws Exception {
        GwtMockito.useProviderForType(ListBox.class, (FakeProvider)new FakeProvider<ListBox>(){

            public ListBox getFake(Class<?> aClass) {
                return RuleModellerConditionSelectorPopupTest.this.choices;
            }
        });
        this.incrementalDataModelServiceCaller = new CallerMock((Object)this.incrementalDataModelService);
        this.validatorInstance = new MockInstanceImpl((Object[])new DynamicValidator[0]);
        this.oracle = (AsyncPackageDataModelOracle)Mockito.spy((Object)new AsyncPackageDataModelOracleImpl(this.incrementalDataModelServiceCaller, this.validatorInstance));
        ((SyncBeanManager)Mockito.doReturn((Object)this.syncBeanDef).when((Object)this.syncBeanManager)).lookupBean(AsyncPackageDataModelOracle.class, new Annotation[0]);
        ((SyncBeanDef)Mockito.doReturn((Object)this.oracle).when((Object)this.syncBeanDef)).getInstance();
    }

    @Test
    public void testLoadDslConditionsDslEnabledButNotPresent() throws Exception {
        ((RuleModeller)Mockito.doReturn((Object)true).when((Object)this.ruleModeller)).isDSLEnabled();
        this.dataModel = PackageDataModelOracleBuilder.newPackageOracleBuilder((MVELEvaluator)new RawMVELEvaluator()).build();
        this.dataModelPayload = new PackageDataModelOracleBaselinePayload();
        this.dataModelPayload.setAllPackageElements(this.dataModel.getAllExtensions());
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, this.dataModelPayload);
        new RuleModellerConditionSelectorPopup(this.model, this.ruleModeller, Integer.valueOf(0), this.oracle);
        ((ListBox)Mockito.verify((Object)this.choices, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), (String)this.valueCaptor.capture());
        Assertions.assertThat((List)this.keyCaptor.getAllValues()).doesNotContain((Object[])new String[]{DSL_SENTENCE_CHOICE_KEY});
        Assertions.assertThat((List)this.valueCaptor.getAllValues()).doesNotContain((Object[])new String[]{DSL_SENTENCE_CHOICE_VALUE});
    }

    @Test
    public void testLoadDslConditionsDslEnabledAndPresent() throws Exception {
        ((RuleModeller)Mockito.doReturn((Object)true).when((Object)this.ruleModeller)).isDSLEnabled();
        this.dataModel = PackageDataModelOracleBuilder.newPackageOracleBuilder((MVELEvaluator)new RawMVELEvaluator()).addExtension((ExtensionKind)DSLConditionSentence.INSTANCE, Collections.singletonList(this.dslSentence)).build();
        this.dataModelPayload = new PackageDataModelOracleBaselinePayload();
        this.dataModelPayload.setAllPackageElements(this.dataModel.getAllExtensions());
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, this.dataModelPayload);
        new RuleModellerConditionSelectorPopup(this.model, this.ruleModeller, Integer.valueOf(0), this.oracle);
        ((ListBox)Mockito.verify((Object)this.choices, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), (String)this.valueCaptor.capture());
        ((ListBox)Mockito.verify((Object)this.choices)).setMultipleSelect(true);
        Assertions.assertThat((List)this.keyCaptor.getAllValues()).contains((Object[])new String[]{DSL_SENTENCE_CHOICE_KEY});
        Assertions.assertThat((List)this.valueCaptor.getAllValues()).contains((Object[])new String[]{DSL_SENTENCE_CHOICE_VALUE});
    }

    @Test
    public void testLoadDslConditionsPresentButDslDisabled() throws Exception {
        ((RuleModeller)Mockito.doReturn((Object)false).when((Object)this.ruleModeller)).isDSLEnabled();
        this.dataModel = PackageDataModelOracleBuilder.newPackageOracleBuilder((MVELEvaluator)new RawMVELEvaluator()).addExtension((ExtensionKind)DSLConditionSentence.INSTANCE, Collections.singletonList(this.dslSentence)).build();
        this.dataModelPayload = new PackageDataModelOracleBaselinePayload();
        this.dataModelPayload.setAllPackageElements(this.dataModel.getAllExtensions());
        this.asyncPackageDataModelOracleFactory.makeAsyncPackageDataModelOracle(this.resourcePath, this.dataModelPayload);
        new RuleModellerConditionSelectorPopup(this.model, this.ruleModeller, Integer.valueOf(0), this.oracle);
        ((ListBox)Mockito.verify((Object)this.choices, (VerificationMode)Mockito.atLeastOnce())).addItem((String)this.keyCaptor.capture(), (String)this.valueCaptor.capture());
        ((ListBox)Mockito.verify((Object)this.choices)).setMultipleSelect(true);
        Assertions.assertThat((List)this.keyCaptor.getAllValues()).doesNotContain((Object[])new String[]{DSL_SENTENCE_CHOICE_KEY});
        Assertions.assertThat((List)this.valueCaptor.getAllValues()).doesNotContain((Object[])new String[]{DSL_SENTENCE_CHOICE_VALUE});
    }
}

