/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldNature;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.MethodParameterValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.util.FieldNatureUtil;
import org.drools.workbench.screens.guided.rule.client.widget.FactTypeKnownValueChangeEvent;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.gwtbootstrap3.client.ui.ListBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class ActionCallMethodWidget
extends RuleModellerWidget {
    private final ActionCallMethod model;
    private final FlexTable layout = new FlexTable();
    private final AsyncPackageDataModelOracle oracle;
    private boolean isBoundFact = false;
    private String[] fieldCompletionTexts;
    private String[] fieldCompletionValues;
    private String variableClass;
    private boolean readOnly;
    private boolean isFactTypeKnown = false;
    private static final String READ_ONLY_STYLE_NAME = "editor-disabled-widget";

    public ActionCallMethodWidget(RuleModeller mod, EventBus eventBus, ActionCallMethod actionCallMethod, Boolean readOnly) {
        super(mod, eventBus);
        this.model = actionCallMethod;
        this.oracle = this.getModeller().getDataModelOracle();
        this.getMethodInfos();
        this.checkIfReadOnly(readOnly);
        this.initWidget((Widget)this.layout);
    }

    private void getMethodInfos() {
        if (this.oracle.isGlobalVariable(this.model.getVariable())) {
            this.getMethodInfosForGlobalVariable();
        } else {
            this.getMethodInfosForBasicFactType();
        }
    }

    private void checkIfReadOnly(Boolean readOnly) {
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName(READ_ONLY_STYLE_NAME);
        } else {
            this.layout.removeStyleName(READ_ONLY_STYLE_NAME);
        }
        this.doLayout();
    }

    private void getMethodInfosForBasicFactType() {
        String factType = this.getFactTypeLHS();
        if (factType == null) {
            factType = this.getFactTypeFromRHS();
        }
        if (factType == null) {
            factType = this.getFactTypeFromLHSField();
        }
        if (factType != null) {
            this.setMethodInfos(factType);
        } else {
            this.checkIfReadOnly(null);
        }
    }

    private String getFactTypeFromLHSField() {
        SingleFieldConstraint lhsBoundField = this.modeller.getModel().getLHSBoundField(this.model.getVariable());
        if (lhsBoundField != null) {
            return this.oracle.getFieldClassName(lhsBoundField.getFactType(), lhsBoundField.getFieldName());
        }
        return null;
    }

    private String getFactTypeFromRHS() {
        ActionInsertFact rhsBoundFact = this.modeller.getModel().getRHSBoundFact(this.model.getVariable());
        if (rhsBoundFact != null) {
            return rhsBoundFact.getFactType();
        }
        return null;
    }

    private String getFactTypeLHS() {
        FactPattern lhsBoundFact = this.modeller.getModel().getLHSBoundFact(this.model.getVariable());
        if (lhsBoundFact != null) {
            return lhsBoundFact.getFactType();
        }
        return null;
    }

    private void setMethodInfos(final String factType) {
        this.oracle.getMethodInfos(factType, (Callback)new Callback<List<MethodInfo>>(){

            public void callback(List<MethodInfo> methodInfos) {
                ActionCallMethodWidget.this.checkIfFactTypeKnown(methodInfos);
                ActionCallMethodWidget.this.checkIfReadOnly(null);
                ActionCallMethodWidget.this.setMethodInfos(methodInfos, factType);
                ActionCallMethodWidget.this.isBoundFact = true;
            }
        });
    }

    private void checkIfFactTypeKnown(List<MethodInfo> methodInfos) {
        if (methodInfos != null) {
            this.isFactTypeKnown = true;
        }
        if (!this.isFactTypeKnown) {
            this.isFactTypeKnown = this.oracle.isFactTypeRecognized(this.variableClass);
        }
        this.fireEvent(new FactTypeKnownValueChangeEvent());
    }

    private void setMethodInfos(List<MethodInfo> methodInfos, String factType) {
        this.fieldCompletionTexts = new String[methodInfos.size()];
        this.fieldCompletionValues = new String[methodInfos.size()];
        int i = 0;
        for (MethodInfo methodInfo : methodInfos) {
            this.fieldCompletionTexts[i] = methodInfo.getName();
            this.fieldCompletionValues[i] = methodInfo.getNameWithParameters();
            ++i;
        }
        this.variableClass = factType;
    }

    private void getMethodInfosForGlobalVariable() {
        this.oracle.getMethodInfosForGlobalVariable(this.model.getVariable(), (Callback)new Callback<List<MethodInfo>>(){

            public void callback(List<MethodInfo> methodInfos) {
                if (methodInfos != null) {
                    ActionCallMethodWidget.this.checkIfFactTypeKnown(methodInfos);
                    ActionCallMethodWidget.this.setMethodInfos(methodInfos, ActionCallMethodWidget.this.oracle.getGlobalVariable(ActionCallMethodWidget.this.model.getVariable()));
                    ActionCallMethodWidget.this.checkIfReadOnly(null);
                } else {
                    ActionCallMethodWidget.access$602(ActionCallMethodWidget.this, new String[0]);
                    ActionCallMethodWidget.access$702(ActionCallMethodWidget.this, new String[0]);
                    ActionCallMethodWidget.this.checkIfReadOnly(true);
                }
            }
        });
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        FlexTable inner = new FlexTable();
        for (int i = 0; i < this.model.getFieldValues().length; ++i) {
            ActionFieldFunction val = this.model.getFieldValue(i);
            inner.setWidget(i, 0, this.typeLabel(val.getType()));
            inner.setWidget(i, 1, this.valueEditor(val));
        }
        this.layout.setWidget(0, 1, (Widget)inner);
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        if (this.model.getState() == 0) {
            Image edit = GuidedRuleEditorImages508.INSTANCE.AddFieldToFact();
            edit.setAltText(GuidedRuleEditorResources.CONSTANTS.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.setTitle(GuidedRuleEditorResources.CONSTANTS.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Widget w = (Widget)event.getSource();
                    ActionCallMethodWidget.this.showAddFieldPopup(w);
                }
            });
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.model.getVariable() + "]"));
            if (!this.readOnly) {
                horiz.add((Widget)edit);
            }
        } else {
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.model.getVariable() + "." + this.model.getMethodName() + "]"));
        }
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        final AsyncPackageDataModelOracle oracle = this.getModeller().getDataModelOracle();
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.ChooseAMethodToInvoke());
        final ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletionTexts.length; ++i) {
            box.addItem(this.fieldCompletionValues[i], this.fieldCompletionTexts[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.ChooseAMethodToInvoke(), (IsWidget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String methodNameWithParams = box.getItemText(box.getSelectedIndex());
                oracle.getMethodParams(ActionCallMethodWidget.this.variableClass, methodNameWithParams, (Callback)new Callback<List<String>>(){

                    public void callback(List<String> methodParameters) {
                        String methodName = box.getValue(box.getSelectedIndex());
                        ActionCallMethodWidget.this.model.setMethodName(methodName);
                        ActionCallMethodWidget.this.model.setState(1);
                        for (String methodParameter : methodParameters) {
                            ActionCallMethodWidget.this.model.addFieldValue((ActionFieldValue)new ActionFieldFunction(methodName, null, methodParameter));
                        }
                        ActionCallMethodWidget.this.getModeller().refreshWidget();
                        popup.hide();
                    }
                });
            }
        });
        popup.show();
    }

    private Widget valueEditor(ActionFieldFunction val) {
        return new MethodParameterValueEditor(this.oracle, val, this.getEnums(val.getField()), this.getModeller(), new Command(){

            public void execute() {
                ActionCallMethodWidget.this.setModified(true);
            }
        });
    }

    private String getVariableType() {
        String type;
        if (this.oracle.isGlobalVariable(this.model.getVariable())) {
            type = this.oracle.getGlobalVariable(this.model.getVariable());
        } else {
            type = this.getModeller().getModel().getLHSBindingType(this.model.getVariable());
            if (type == null) {
                type = this.getModeller().getModel().getRHSBoundFact(this.model.getVariable()).getFactType();
            }
        }
        return type;
    }

    private DropDownData getEnums(String field) {
        return this.oracle.getEnums(this.getVariableType(), field, FieldNatureUtil.toMap((FieldNature[])this.model.getFieldValues()));
    }

    private Widget typeLabel(String type) {
        return new SmallLabel(type);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    static /* synthetic */ String[] access$602(ActionCallMethodWidget x0, String[] x1) {
        x0.fieldCompletionTexts = x1;
        return x1;
    }

    static /* synthetic */ String[] access$702(ActionCallMethodWidget x0, String[] x1) {
        x0.fieldCompletionValues = x1;
        return x1;
    }
}

