/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.attribute;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.GuidedRuleAttributeSelectorPopup;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={GuidedRuleEditorImages508.class, Text.class, DateTimeFormat.class})
public class GuidedRuleAttributeSelectorPopupTest {
    private RuleModel model;
    private boolean lockLHS = false;
    private boolean lockRHS = false;
    @Mock
    private Command refreshCommand;
    private GuidedRuleAttributeSelectorPopup popup;

    @Before
    public void setUp() throws Exception {
        this.model = new RuleModel();
        this.popup = new GuidedRuleAttributeSelectorPopup();
        this.popup.init(this.model, this.lockLHS, this.lockRHS, this.refreshCommand);
    }

    @Test
    public void testHandleAttributeAddition_Calendars() {
        this.popup.handleAttributeAddition(Attribute.CALENDARS.getAttributeName());
        Assertions.assertThat((Object[])this.model.attributes).containsExactly((Object[])new RuleAttribute[]{new RuleAttribute(Attribute.CALENDARS.getAttributeName(), "")});
        Assertions.assertThat((Object[])this.model.metadataList).isEmpty();
        ((Command)Mockito.verify((Object)this.refreshCommand)).execute();
    }

    @Test
    public void testHandleAttributeAddition_Timer() {
        this.popup.handleAttributeAddition(Attribute.TIMER.getAttributeName());
        Assertions.assertThat((Object[])this.model.attributes).containsExactly((Object[])new RuleAttribute[]{new RuleAttribute(Attribute.TIMER.getAttributeName(), "")});
        Assertions.assertThat((Object[])this.model.metadataList).isEmpty();
        ((Command)Mockito.verify((Object)this.refreshCommand)).execute();
    }

    @Test
    public void testHandleAttributeAddition_LockRHS() {
        this.popup.handleAttributeAddition("freeze_actions");
        Assertions.assertThat((Object[])this.model.attributes).isEmpty();
        Assertions.assertThat((Object[])this.model.metadataList).containsExactly((Object[])new RuleMetadata[]{new RuleMetadata("freeze_actions", "true")});
        ((Command)Mockito.verify((Object)this.refreshCommand)).execute();
    }

    @Test
    public void testHandleAttributeAddition_LockLHS() {
        this.popup.handleAttributeAddition("freeze_conditions");
        Assertions.assertThat((Object[])this.model.attributes).isEmpty();
        Assertions.assertThat((Object[])this.model.metadataList).containsExactly((Object[])new RuleMetadata[]{new RuleMetadata("freeze_conditions", "true")});
        ((Command)Mockito.verify((Object)this.refreshCommand)).execute();
    }

    @Test
    public void testHandleMetadataAddition() {
        String metadata = "a_b_c";
        this.popup.handleMetadataAddition("a_b_c");
        Assertions.assertThat((Object[])this.model.attributes).isEmpty();
        Assertions.assertThat((Object[])this.model.metadataList).containsExactly((Object[])new RuleMetadata[]{new RuleMetadata("a_b_c", "")});
    }

    @Test
    public void testIsMetadataUnique() {
        String metadataOne = "a_b";
        String metadataTwo = "c_d";
        this.model.addMetadata(new RuleMetadata("a_b", ""));
        this.model.addMetadata(new RuleMetadata("c_d", ""));
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("A_b")).isTrue();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("a_B")).isTrue();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("a_b_c")).isTrue();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("c_D")).isTrue();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("C_D")).isTrue();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("a_c_c")).isTrue();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("a_b")).isFalse();
        Assertions.assertThat((boolean)this.popup.isMetadataUnique("c_d")).isFalse();
    }
}

