/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.AddConstraintButton;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.TemplateKeyTextBox;
import org.drools.workbench.screens.guided.rule.client.widget.EnumDropDown;
import org.guvnor.common.services.workingset.client.WorkingSetManager;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.widget.LiteralTextBox;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@WithClassesToStub(value={AddConstraintButton.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class ConstraintValueEditorTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private SingleFieldConstraint constraint;
    @Mock
    private WorkingSetManager wsManager;
    @GwtMock
    private RuleModeller ruleModeller;
    @Mock
    private TemplateKeyTextBox templateKeyTextBox;

    @Before
    public void setup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("drools.dateformat", "dd MMM yyyy");
        ApplicationPreferences.setUp(map);
        Mockito.when((Object)this.ruleModeller.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.getFieldType(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)this.constraint.getConstraintValueType()).thenReturn((Object)1);
    }

    @Test
    public void correctWidgetForStringField() {
        ConstraintValueEditor editor = this.createEditor((BaseSingleFieldConstraint)this.constraint);
        Assert.assertTrue((boolean)(editor.getConstraintWidget() instanceof LiteralTextBox));
    }

    @Test
    public void correctWidgetForStringFieldValueInList() {
        Mockito.when((Object)this.constraint.getOperator()).thenReturn((Object)"in");
        ConstraintValueEditor editor = this.createEditor((BaseSingleFieldConstraint)this.constraint);
        Assert.assertTrue((boolean)(editor.getConstraintWidget() instanceof LiteralTextBox));
    }

    @Test
    public void correctWidgetForStringFieldValueNotInList() {
        Mockito.when((Object)this.constraint.getOperator()).thenReturn((Object)"not in");
        ConstraintValueEditor editor = this.createEditor((BaseSingleFieldConstraint)this.constraint);
        Assert.assertTrue((boolean)(editor.getConstraintWidget() instanceof LiteralTextBox));
    }

    @Test
    public void defaultTextBoxHasHandlersAttachedInCorrectOrder() {
        TextBox defaultTextBox = (TextBox)Mockito.mock(TextBox.class);
        ConstraintValueEditor editor = (ConstraintValueEditor)Mockito.spy((Object)this.createEditor((BaseSingleFieldConstraint)this.constraint));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{editor});
        ((ConstraintValueEditor)Mockito.doReturn((Object)defaultTextBox).when((Object)editor)).getDefaultTextBox((String)Matchers.any(String.class));
        editor.getNewTextBox("String");
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).setUpTextBoxStyleAndHandlers((TextBox)Matchers.eq((Object)defaultTextBox), (Command)Matchers.any(Command.class));
        ((TextBox)Mockito.verify((Object)defaultTextBox, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.any(String.class));
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).attachDisplayLengthHandler((TextBox)Matchers.eq((Object)defaultTextBox));
    }

    @Test
    public void templateKeyEditorHasHandlersAttachedInCorrectOrder() {
        ConstraintValueEditor editor = (ConstraintValueEditor)Mockito.spy((Object)this.createEditor((BaseSingleFieldConstraint)this.constraint));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{editor});
        editor.templateKeyEditor();
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).setUpTextBoxStyleAndHandlers((TextBox)Matchers.eq((Object)this.templateKeyTextBox), (Command)Matchers.any(Command.class));
        ((TemplateKeyTextBox)Mockito.verify((Object)this.templateKeyTextBox, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.any(String.class), ((Boolean)Matchers.any(Boolean.class)).booleanValue());
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).attachDisplayLengthHandler((TextBox)Matchers.eq((Object)this.templateKeyTextBox));
    }

    @Test
    public void testGetDrowpDown() {
        String factType = "Car";
        String factField = "color";
        SingleFieldConstraint singleFieldConstraint = new SingleFieldConstraint(){
            {
                this.setFactType("Car");
                this.setFieldName("color");
            }
        };
        ConstraintValueEditor editor = (ConstraintValueEditor)Mockito.spy((Object)this.createEditor((BaseSingleFieldConstraint)singleFieldConstraint));
        Mockito.reset((Object[])new AsyncPackageDataModelOracle[]{this.oracle});
        editor.initDropDownData();
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).getEnums((String)Matchers.eq((Object)"Car"), (String)Matchers.eq((Object)"color"), Matchers.anyMap());
    }

    @Test
    public void testInitDropDown_BooleanFieldType() {
        String factType = "Car";
        String factField = "cheap";
        Mockito.reset((Object[])new AsyncPackageDataModelOracle[]{this.oracle});
        Mockito.when((Object)this.oracle.getFieldType("Car", "cheap")).thenReturn((Object)"Boolean");
        SingleFieldConstraint singleFieldConstraint = new SingleFieldConstraint(){
            {
                this.setFactType("Car");
                this.setFieldName("cheap");
                this.setConstraintValueType(1);
            }
        };
        ConstraintValueEditor editor = (ConstraintValueEditor)Mockito.spy((Object)this.createEditor((BaseSingleFieldConstraint)singleFieldConstraint));
        editor.initDropDownData();
        editor.refresh();
        Assertions.assertThat((Object)editor.getConstraintWidget()).isInstanceOf(EnumDropDown.class);
    }

    @Test
    public void testInitializationOrder() {
        SingleFieldConstraint singleFieldConstraint = (SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class);
        ConstraintValueEditor editor = (ConstraintValueEditor)Mockito.spy((Object)this.createEditor((BaseSingleFieldConstraint)singleFieldConstraint));
        editor.init();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{editor});
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).initDropDownData();
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).constructConstraintValueEditorHelper();
        ((ConstraintValueEditor)inOrder.verify((Object)editor)).refresh();
    }

    private ConstraintValueEditor createEditor(BaseSingleFieldConstraint baseConstraint) {
        ConstraintValueEditor editor = new ConstraintValueEditor(baseConstraint, (CompositeFieldConstraint)Mockito.mock(CompositeFieldConstraint.class), this.ruleModeller, (EventBus)Mockito.mock(EventBus.class), false){

            void setBoxSize(TextBox box) {
            }

            Widget wrap(Widget widget) {
                return widget;
            }

            WorkingSetManager getWorkingSetManager() {
                return ConstraintValueEditorTest.this.wsManager;
            }

            TemplateKeyTextBox getTemplateKeyTextBox() {
                return ConstraintValueEditorTest.this.templateKeyTextBox;
            }
        };
        editor.init();
        return editor;
    }
}

