/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.screens.guided.rule.client.editor.ActionValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.widget.ActionInsertFactWidget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={FlexTable.class, DateTimeFormat.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class ActionInsertFactWidgetTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private RuleModeller modeller;
    @Mock
    private EventBus eventBus;
    @Mock
    private ActionInsertFact action;
    private boolean readOnly = false;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;
    private ActionInsertFactWidget testedWidget;

    @Before
    public void setUp() throws Exception {
        ((RuleModeller)Mockito.doReturn((Object)this.oracle).when((Object)this.modeller)).getDataModelOracle();
        ((ActionInsertFact)Mockito.doReturn((Object)new ActionFieldValue[0]).when((Object)this.action)).getFieldValues();
        this.testedWidget = (ActionInsertFactWidget)Mockito.spy((Object)new ActionInsertFactWidget(this.modeller, this.eventBus, this.action, Boolean.valueOf(this.readOnly)));
    }

    @Test
    public void testOnChangeCallbackRegisteredForActionValueEditor() throws Exception {
        ActionFieldValue value = new ActionFieldValue();
        value.setNature(1);
        value.setField("a");
        ActionValueEditor editor = (ActionValueEditor)Mockito.mock(ActionValueEditor.class);
        ((ActionInsertFactWidget)Mockito.doReturn((Object)editor).when((Object)this.testedWidget)).actionValueEditor(Matchers.anyString(), (ActionFieldValue)Matchers.eq((Object)value), (ActionFieldValue[])Matchers.any(), Matchers.eq((boolean)this.readOnly));
        ActionFieldValue valueTwo = new ActionFieldValue();
        valueTwo.setNature(1);
        valueTwo.setField("b");
        ActionValueEditor editorTwo = (ActionValueEditor)Mockito.mock(ActionValueEditor.class);
        ((ActionInsertFactWidget)Mockito.doReturn((Object)editorTwo).when((Object)this.testedWidget)).actionValueEditor(Matchers.anyString(), (ActionFieldValue)Matchers.eq((Object)valueTwo), (ActionFieldValue[])Matchers.any(), Matchers.eq((boolean)this.readOnly));
        this.testedWidget.valueEditor(value);
        this.testedWidget.valueEditor(valueTwo);
        ((ActionValueEditor)Mockito.verify((Object)editor)).setOnChangeCommand((Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ActionInsertFactWidget)Mockito.verify((Object)this.testedWidget)).setModified(true);
        ((ActionValueEditor)Mockito.verify((Object)editorTwo)).refresh();
    }
}

