/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor.factPattern;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionUnboundFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.HasConstraints;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.kie.workbench.common.widgets.client.widget.BindingTextBox;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class PopupCreator {
    private FactPattern pattern;
    private AsyncPackageDataModelOracle oracle;
    private RuleModeller modeller;
    private boolean bindable;

    public FactPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(FactPattern pattern) {
        this.pattern = pattern;
    }

    public AsyncPackageDataModelOracle getDataModelOracle() {
        return this.oracle;
    }

    public void setDataModelOracle(AsyncPackageDataModelOracle oracle) {
        this.oracle = oracle;
    }

    public RuleModeller getModeller() {
        return this.modeller;
    }

    public void setModeller(RuleModeller modeller) {
        this.modeller = modeller;
    }

    public boolean isBindable() {
        return this.bindable;
    }

    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    public void showBindFieldPopup(final FactPattern fp, final SingleFieldConstraint con, ModelField[] fields, final PopupCreator popupCreator) {
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorResources.CONSTANTS.AddAField());
        HorizontalPanel vn = new HorizontalPanel();
        BindingTextBox varName = new BindingTextBox();
        if (con.getFieldBinding() != null) {
            varName.setText(con.getFieldBinding());
        }
        Button ok = new Button(HumanReadableConstants.INSTANCE.Set());
        vn.add((Widget)varName);
        vn.add((Widget)ok);
        ok.addClickHandler(new ClickHandler((TextBox)varName, con, popup){
            final /* synthetic */ TextBox val$varName;
            final /* synthetic */ SingleFieldConstraint val$con;
            final /* synthetic */ FormStylePopup val$popup;
            {
                this.val$varName = textBox;
                this.val$con = singleFieldConstraint;
                this.val$popup = formStylePopup;
            }

            public void onClick(ClickEvent event) {
                String var = this.val$varName.getText();
                if (PopupCreator.this.modeller.isVariableNameUsed(var)) {
                    Window.alert((String)GuidedRuleEditorResources.CONSTANTS.TheVariableName0IsAlreadyTaken(var));
                    return;
                }
                this.val$con.setFieldBinding(var);
                PopupCreator.this.modeller.refreshWidget();
                this.val$popup.hide();
            }
        });
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.BindTheFieldCalled0ToAVariable(con.getFieldName()), (IsWidget)vn);
        if (this.hasApplicableFields(fields)) {
            Button sub = new Button(GuidedRuleEditorResources.CONSTANTS.ShowSubFields());
            popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.ApplyAConstraintToASubFieldOf0(con.getFieldName()), (IsWidget)sub);
            sub.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    popup.hide();
                    popupCreator.showPatternPopup(fp, con, true);
                }
            });
        }
        popup.show();
    }

    private boolean hasApplicableFields(ModelField[] fields) {
        if (fields == null || fields.length == 0) {
            return false;
        }
        if (fields.length > 1) {
            return true;
        }
        return !"this".equals(fields[0].getName());
    }

    public void showPatternPopupForComposite(final HasConstraints hasConstraints) {
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), GuidedRuleEditorResources.CONSTANTS.AddFieldsToThisConstraint());
        final ListBox box = new ListBox();
        box.addItem("...");
        this.oracle.getFieldCompletions(this.pattern.getFactType(), (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                for (int i = 0; i < fields.length; ++i) {
                    String fieldName = fields[i].getName();
                    box.addItem(fieldName);
                }
            }
        });
        box.setSelectedIndex(0);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String factType = PopupCreator.this.pattern.getFactType();
                String fieldName = box.getItemText(box.getSelectedIndex());
                String fieldType = PopupCreator.this.getDataModelOracle().getFieldType(factType, fieldName);
                hasConstraints.addConstraint((FieldConstraint)new SingleFieldConstraint(factType, fieldName, fieldType, null));
                PopupCreator.this.modeller.refreshWidget();
                popup.hide();
            }
        });
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.AddARestrictionOnAField(), (IsWidget)box);
        final ListBox composites = new ListBox();
        composites.addItem("...");
        composites.addItem(GuidedRuleEditorResources.CONSTANTS.AllOfAnd(), "&&");
        composites.addItem(GuidedRuleEditorResources.CONSTANTS.AnyOfOr(), "||");
        composites.setSelectedIndex(0);
        composites.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CompositeFieldConstraint comp = new CompositeFieldConstraint();
                comp.setCompositeJunctionType(composites.getValue(composites.getSelectedIndex()));
                hasConstraints.addConstraint((FieldConstraint)comp);
                PopupCreator.this.modeller.refreshWidget();
                popup.hide();
            }
        });
        InfoPopup infoComp = new InfoPopup(GuidedRuleEditorResources.CONSTANTS.MultipleFieldConstraints(), GuidedRuleEditorResources.CONSTANTS.MultipleConstraintsTip());
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.add((Widget)composites);
        horiz.add((IsWidget)infoComp);
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.MultipleFieldConstraint(), (IsWidget)horiz);
        popup.addRow((IsWidget)new SmallLabel("<i>" + GuidedRuleEditorResources.CONSTANTS.AdvancedOptionsColon() + "</i>"));
        Button predicate = new Button(GuidedRuleEditorResources.CONSTANTS.NewFormula());
        predicate.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SingleFieldConstraint con = new SingleFieldConstraint();
                con.setConstraintValueType(5);
                hasConstraints.addConstraint((FieldConstraint)con);
                PopupCreator.this.modeller.refreshWidget();
                popup.hide();
            }
        });
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.AddANewFormulaStyleExpression(), (IsWidget)predicate);
        Button expressionEditorButton = this.makeExpressionEditorButton(hasConstraints, popup);
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor(), (IsWidget)expressionEditorButton);
        popup.show();
    }

    public void showPatternPopup(final FactPattern fp, final SingleFieldConstraint con, final boolean isNested) {
        final String factType = this.getFactType(fp, con);
        String title = con == null ? GuidedRuleEditorResources.CONSTANTS.ModifyConstraintsFor0(fp.getFactType()) : GuidedRuleEditorResources.CONSTANTS.AddSubFieldConstraint();
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorImages508.INSTANCE.Wizard(), title);
        final ListBox box = new ListBox();
        box.addItem("...");
        this.oracle.getFieldCompletions(factType, FieldAccessorsAndMutators.ACCESSOR, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                for (int i = 0; i < fields.length; ++i) {
                    String fieldName = fields[i].getName();
                    if (isNested && fieldName.equals("this")) continue;
                    box.addItem(fieldName);
                }
            }
        });
        box.setSelectedIndex(0);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fieldName = box.getItemText(box.getSelectedIndex());
                if ("...".equals(fieldName)) {
                    return;
                }
                String fieldType = PopupCreator.this.oracle.getFieldType(factType, fieldName);
                fp.addConstraint((FieldConstraint)new SingleFieldConstraint(factType, fieldName, fieldType, (FieldConstraint)con));
                PopupCreator.this.modeller.refreshWidget();
                popup.hide();
            }
        });
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.AddARestrictionOnAField(), (IsWidget)box);
        final ListBox composites = new ListBox();
        composites.addItem("...");
        composites.addItem(GuidedRuleEditorResources.CONSTANTS.AllOfAnd(), "&&");
        composites.addItem(GuidedRuleEditorResources.CONSTANTS.AnyOfOr(), "||");
        composites.setSelectedIndex(0);
        composites.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CompositeFieldConstraint comp = new CompositeFieldConstraint();
                comp.setCompositeJunctionType(composites.getValue(composites.getSelectedIndex()));
                fp.addConstraint((FieldConstraint)comp);
                PopupCreator.this.modeller.refreshWidget();
                popup.hide();
            }
        });
        InfoPopup infoComp = new InfoPopup(GuidedRuleEditorResources.CONSTANTS.MultipleFieldConstraints(), GuidedRuleEditorResources.CONSTANTS.MultipleConstraintsTip1());
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.add((Widget)composites);
        horiz.add((IsWidget)infoComp);
        if (con == null) {
            popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.MultipleFieldConstraint(), (IsWidget)horiz);
        }
        if (con == null) {
            popup.addRow((IsWidget)new SmallLabel("<i>" + GuidedRuleEditorResources.CONSTANTS.AdvancedOptionsColon() + "</i>"));
            Button predicate = new Button(GuidedRuleEditorResources.CONSTANTS.NewFormula());
            predicate.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SingleFieldConstraint con = new SingleFieldConstraint();
                    con.setConstraintValueType(5);
                    fp.addConstraint((FieldConstraint)con);
                    PopupCreator.this.modeller.refreshWidget();
                    popup.hide();
                }
            });
            popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.AddANewFormulaStyleExpression(), (IsWidget)predicate);
            Button expressionEditorButton = this.makeExpressionEditorButton((HasConstraints)fp, popup);
            popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor(), (IsWidget)expressionEditorButton);
            this.doBindingEditor(popup);
        }
        popup.show();
    }

    Button makeExpressionEditorButton(HasConstraints hasConstraints, FormStylePopup popup) {
        Button button = this.makeExpressionEditorButton();
        button.addClickHandler(this.onExpressionEditorButtonClick(hasConstraints, popup));
        return button;
    }

    Button makeExpressionEditorButton() {
        return new Button(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor());
    }

    ClickHandler onExpressionEditorButtonClick(HasConstraints hasConstraints, FormStylePopup popup) {
        return event -> {
            String factType = this.getPattern().getFactType();
            SingleFieldConstraintEBLeftSide constraint = this.makeSingleFieldConstraintEBLeftSide(factType);
            hasConstraints.addConstraint((FieldConstraint)constraint);
            this.getModeller().refreshWidget();
            popup.hide();
        };
    }

    SingleFieldConstraintEBLeftSide makeSingleFieldConstraintEBLeftSide(String factType) {
        SingleFieldConstraintEBLeftSide constraint = new SingleFieldConstraintEBLeftSide();
        ExpressionFormLine expression = this.makeExpressionFormLine(factType);
        constraint.setConstraintValueType(0);
        constraint.setExpressionLeftSide(expression);
        constraint.setFactType(factType);
        return constraint;
    }

    ExpressionFormLine makeExpressionFormLine(String factType) {
        ExpressionUnboundFact part = new ExpressionUnboundFact(factType);
        return new ExpressionFormLine((ExpressionPart)part);
    }

    private String getFactType(FactPattern fp, SingleFieldConstraint sfc) {
        String factType;
        if (sfc == null) {
            factType = fp.getFactType();
        } else {
            factType = sfc.getFieldType();
            String fieldName = sfc.getFieldName();
            if ("this".equals(fieldName)) {
                factType = fp.getFactType();
            }
        }
        return factType;
    }

    private void doBindingEditor(FormStylePopup popup) {
        if (this.bindable || !this.modeller.getModel().isBoundFactUsed(this.pattern.getBoundName())) {
            HorizontalPanel varName = new HorizontalPanel();
            BindingTextBox varTxt = new BindingTextBox();
            if (this.pattern.getBoundName() == null) {
                varTxt.setText("");
            } else {
                varTxt.setText(this.pattern.getBoundName());
            }
            ((InputElement)varTxt.getElement().cast()).setSize(6);
            varName.add((Widget)varTxt);
            Button bindVar = new Button(HumanReadableConstants.INSTANCE.Set());
            bindVar.addClickHandler(new ClickHandler((TextBox)varTxt, popup){
                final /* synthetic */ TextBox val$varTxt;
                final /* synthetic */ FormStylePopup val$popup;
                {
                    this.val$varTxt = textBox;
                    this.val$popup = formStylePopup;
                }

                public void onClick(ClickEvent event) {
                    String var = this.val$varTxt.getText();
                    if (PopupCreator.this.modeller.isVariableNameUsed(var)) {
                        Window.alert((String)GuidedRuleEditorResources.CONSTANTS.TheVariableName0IsAlreadyTaken(var));
                        return;
                    }
                    PopupCreator.this.pattern.setBoundName(this.val$varTxt.getText());
                    PopupCreator.this.modeller.refreshWidget();
                    this.val$popup.hide();
                }
            });
            varName.add((Widget)bindVar);
            popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.VariableName(), (IsWidget)varName);
        }
    }
}

