/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.util;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.ActionValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.util.RefreshUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@WithClassesToStub(value={DateTimeFormat.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class RefreshUtilTest {
    @Test
    public void testConstraintValueEditorRefreshPredicateNotRefreshed() throws Exception {
        SingleFieldConstraint constraintOne = (SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class);
        SingleFieldConstraint constraintTwo = (SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class);
        ConstraintValueEditor editorOne = (ConstraintValueEditor)Mockito.mock(ConstraintValueEditor.class);
        ConstraintValueEditor editorTwo = (ConstraintValueEditor)Mockito.mock(ConstraintValueEditor.class);
        HashMap<SingleFieldConstraint, ConstraintValueEditor> editors = new HashMap<SingleFieldConstraint, ConstraintValueEditor>();
        editors.put(constraintOne, editorOne);
        editors.put(constraintTwo, editorTwo);
        ((SingleFieldConstraint)Mockito.doReturn((Object)1).when((Object)constraintOne)).getConstraintValueType();
        ((SingleFieldConstraint)Mockito.doReturn((Object)5).when((Object)constraintTwo)).getConstraintValueType();
        RefreshUtil.refreshConstraintValueEditorsDropDownData(editors, (SingleFieldConstraint)((SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class)));
        ((ConstraintValueEditor)Mockito.verify((Object)editorOne)).refresh();
        ((ConstraintValueEditor)Mockito.verify((Object)editorTwo, (VerificationMode)Mockito.never())).refresh();
    }

    @Test
    public void testConstraintValueEditorRefreshMultipleEditors() throws Exception {
        SingleFieldConstraint constraintOne = (SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class);
        SingleFieldConstraint constraintTwo = (SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class);
        ConstraintValueEditor editorOne = (ConstraintValueEditor)Mockito.mock(ConstraintValueEditor.class);
        ConstraintValueEditor editorTwo = (ConstraintValueEditor)Mockito.mock(ConstraintValueEditor.class);
        HashMap<SingleFieldConstraint, ConstraintValueEditor> editors = new HashMap<SingleFieldConstraint, ConstraintValueEditor>();
        editors.put(constraintOne, editorOne);
        editors.put(constraintTwo, editorTwo);
        ((SingleFieldConstraint)Mockito.doReturn((Object)1).when((Object)constraintOne)).getConstraintValueType();
        ((SingleFieldConstraint)Mockito.doReturn((Object)1).when((Object)constraintTwo)).getConstraintValueType();
        RefreshUtil.refreshConstraintValueEditorsDropDownData(editors, (SingleFieldConstraint)((SingleFieldConstraint)Mockito.mock(SingleFieldConstraint.class)));
        ((ConstraintValueEditor)Mockito.verify((Object)editorOne)).refresh();
        ((ConstraintValueEditor)Mockito.verify((Object)editorTwo)).refresh();
    }

    @Test
    public void testActionValueEditorRefreshPredicateNotRefreshed() throws Exception {
        ActionFieldValue valueOne = (ActionFieldValue)Mockito.mock(ActionFieldValue.class);
        ActionFieldValue valueTwo = (ActionFieldValue)Mockito.mock(ActionFieldValue.class);
        ActionValueEditor editorOne = (ActionValueEditor)Mockito.mock(ActionValueEditor.class);
        ActionValueEditor editorTwo = (ActionValueEditor)Mockito.mock(ActionValueEditor.class);
        HashMap<ActionFieldValue, ActionValueEditor> editors = new HashMap<ActionFieldValue, ActionValueEditor>();
        editors.put(valueOne, editorOne);
        editors.put(valueTwo, editorTwo);
        ((ActionFieldValue)Mockito.doReturn((Object)1).when((Object)valueOne)).getNature();
        ((ActionFieldValue)Mockito.doReturn((Object)5).when((Object)valueTwo)).getNature();
        RefreshUtil.refreshActionValueEditorsDropDownData(editors, (ActionFieldValue)((ActionFieldValue)Mockito.mock(ActionFieldValue.class)));
        ((ActionValueEditor)Mockito.verify((Object)editorOne)).refresh();
        ((ActionValueEditor)Mockito.verify((Object)editorTwo, (VerificationMode)Mockito.never())).refresh();
    }

    @Test
    public void testActionValueEditorRefreshMultipleEditors() throws Exception {
        ActionFieldValue valueOne = (ActionFieldValue)Mockito.mock(ActionFieldValue.class);
        ActionFieldValue valueTwo = (ActionFieldValue)Mockito.mock(ActionFieldValue.class);
        ActionValueEditor editorOne = (ActionValueEditor)Mockito.mock(ActionValueEditor.class);
        ActionValueEditor editorTwo = (ActionValueEditor)Mockito.mock(ActionValueEditor.class);
        HashMap<ActionFieldValue, ActionValueEditor> editors = new HashMap<ActionFieldValue, ActionValueEditor>();
        editors.put(valueOne, editorOne);
        editors.put(valueTwo, editorTwo);
        ((ActionFieldValue)Mockito.doReturn((Object)1).when((Object)valueOne)).getNature();
        ((ActionFieldValue)Mockito.doReturn((Object)1).when((Object)valueTwo)).getNature();
        RefreshUtil.refreshActionValueEditorsDropDownData(editors, (ActionFieldValue)((ActionFieldValue)Mockito.mock(ActionFieldValue.class)));
        ((ActionValueEditor)Mockito.verify((Object)editorOne)).refresh();
        ((ActionValueEditor)Mockito.verify((Object)editorTwo)).refresh();
    }
}

