/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.OperatorsBaseTest;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.rule.client.widget.FactPatternWidget;
import org.drools.workbench.screens.guided.rule.client.widget.operator.SingleFieldConstraintOperatorSelector;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={FlexTable.class, GuidedRuleEditorImages508.class, CEPOperatorsDropdown.class, DateTimeFormat.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class FactPatternWidgetTest
extends OperatorsBaseTest {
    @Mock
    private SingleFieldConstraintOperatorSelector operatorSelector;
    private FactPatternWidget factPatternWidget;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GwtMockito.useProviderForType(SingleFieldConstraintOperatorSelector.class, aClass -> this.operatorSelector);
        ((FactPattern)Mockito.doReturn(Stream.of(this.singleFieldConstraint).toArray(FieldConstraint[]::new)).when((Object)this.pattern)).getFieldConstraints();
        this.factPatternWidget = (FactPatternWidget)Mockito.spy((Object)new FactPatternWidget(this.modeller, this.eventBus, (IPattern)this.pattern, true, Boolean.valueOf(false)));
        ((FactPatternWidget)Mockito.doReturn((Object)this.connectives).when((Object)this.factPatternWidget)).getConnectives();
    }

    @Test
    public void testSingleFieldConstraintOperatorSelectorBuilderCalled() throws Exception {
        ((SingleFieldConstraintOperatorSelector)Mockito.verify((Object)this.operatorSelector)).configure((SingleFieldConstraint)Matchers.eq((Object)this.singleFieldConstraint), (Supplier)Matchers.any(Supplier.class), (Function)Matchers.any(Function.class), (FactPatternWidget)Matchers.any(FactPatternWidget.class), (HorizontalPanel)Matchers.any(HorizontalPanel.class), (FlexTable)Matchers.any(FlexTable.class), Matchers.anyInt(), Matchers.anyInt(), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle));
    }

    @Test
    public void testOnChangeCallbackRegisteredForConstraintValueEditor() throws Exception {
        SingleFieldConstraint constraint = new SingleFieldConstraint();
        constraint.setConstraintValueType(1);
        constraint.setFieldName("a");
        ConstraintValueEditor editor = (ConstraintValueEditor)Mockito.mock(ConstraintValueEditor.class);
        ((FactPatternWidget)Mockito.doReturn((Object)editor).when((Object)this.factPatternWidget)).constraintValueEditor(constraint);
        SingleFieldConstraint constraintTwo = new SingleFieldConstraint();
        constraintTwo.setConstraintValueType(1);
        constraintTwo.setFieldName("b");
        ConstraintValueEditor editorTwo = (ConstraintValueEditor)Mockito.mock(ConstraintValueEditor.class);
        ((FactPatternWidget)Mockito.doReturn((Object)editorTwo).when((Object)this.factPatternWidget)).constraintValueEditor(constraintTwo);
        this.factPatternWidget.createValueEditor(constraint);
        this.factPatternWidget.createValueEditor(constraintTwo);
        ((ConstraintValueEditor)Mockito.verify((Object)editor)).init();
        ((ConstraintValueEditor)Mockito.verify((Object)editorTwo)).init();
        ((ConstraintValueEditor)Mockito.verify((Object)editor)).setOnValueChangeCommand((Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ConstraintValueEditor)Mockito.verify((Object)editorTwo)).hideError();
        ((FactPatternWidget)Mockito.verify((Object)this.factPatternWidget)).setModified(true);
        ((ConstraintValueEditor)Mockito.verify((Object)editorTwo)).refresh();
    }
}

