/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.workbench.models.datamodel.rule.ExpressionFieldVariable;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionMethod;
import org.drools.workbench.models.datamodel.rule.ExpressionMethodParameter;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionText;
import org.drools.workbench.models.datamodel.rule.ExpressionUnboundFact;
import org.drools.workbench.models.datamodel.rule.ExpressionVariable;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.ExpressionChangeEvent;
import org.drools.workbench.screens.guided.rule.client.editor.ExpressionChangeHandler;
import org.drools.workbench.screens.guided.rule.client.editor.ExpressionTypeChangeEvent;
import org.drools.workbench.screens.guided.rule.client.editor.ExpressionTypeChangeHandler;
import org.drools.workbench.screens.guided.rule.client.editor.HasExpressionChangeHandlers;
import org.drools.workbench.screens.guided.rule.client.editor.HasExpressionTypeChangeHandlers;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.ExpressionPartHelper;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.InputGroup;
import org.gwtbootstrap3.client.ui.InputGroupButton;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.MethodInfo;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ClickableLabel;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

public class ExpressionBuilder
extends RuleModellerWidget
implements HasExpressionTypeChangeHandlers,
HasExpressionChangeHandlers {
    private static final String DELETE_VALUE = "_delete_";
    private static final String TEXT_VALUE = "_text_";
    private static final String FIElD_VALUE_PREFIX = "fl";
    private static final String VARIABLE_VALUE_PREFIX = "va";
    private static final String GLOBAL_VARIABLE_VALUE_PREFIX = "gv";
    private static final String METHOD_VALUE_PREFIX = "mt";
    private final SmallLabelClickHandler slch = new SmallLabelClickHandler();
    private HorizontalPanel panel = new HorizontalPanel();
    private ExpressionFormLine expression;
    private boolean readOnly;
    private boolean isFactTypeKnown;

    public ExpressionBuilder(RuleModeller modeller, EventBus eventBus, ExpressionFormLine expression) {
        this(modeller, eventBus, expression, false);
    }

    public ExpressionBuilder(RuleModeller modeller, EventBus eventBus, ExpressionFormLine expression, Boolean readOnly) {
        super(modeller, eventBus);
        this.expression = expression;
        this.isFactTypeKnown = this.expression.isEmpty() ? true : this.getModeller().getDataModelOracle().isFactTypeRecognized(this.getModeller().getDataModelOracle().getFactNameFromType(this.expression.getRootExpression().getClassType()));
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.panel.setStylePrimaryName(GuidedRuleEditorResources.INSTANCE.css().container());
        this.initializeWidgets();
        this.initWidget((Widget)this.panel);
    }

    private void initializeWidgets() {
        this.panel.clear();
        StringBuilder bindingLabel = new StringBuilder();
        String binding = this.getBoundText();
        bindingLabel.append("<b>");
        bindingLabel.append(binding);
        bindingLabel.append("</b>");
        bindingLabel.append(":");
        if (this.isExpressionEmpty()) {
            if (this.readOnly) {
                this.panel.add((Widget)new SmallLabel("<b>-</b>"));
            } else {
                this.panel.add(this.createStartPointWidget());
            }
        } else if (this.readOnly) {
            this.panel.add((Widget)this.createBindingWidgetForExpression(bindingLabel.toString()));
            this.panel.add(this.createWidgetForExpression());
        } else {
            this.panel.add((Widget)this.createBindingWidgetForExpression(bindingLabel.toString()));
            this.panel.add(this.createWidgetForExpression());
            this.panel.add(this.getWidgetForCurrentType());
        }
    }

    private boolean isExpressionEmpty() {
        return this.expression == null || this.expression.isEmpty();
    }

    private String getBoundText() {
        if (this.expression.isBound()) {
            return "[" + this.expression.getBinding() + "] ";
        }
        return "[not bound]";
    }

    private Widget createStartPointWidget() {
        ListBox startPoint = new ListBox();
        startPoint.addItem(GuidedRuleEditorResources.CONSTANTS.Choose(), "");
        for (String gv : this.getDataModelOracle().getGlobalVariables()) {
            startPoint.addItem(gv, "gv." + gv);
        }
        for (String v : this.getRuleModel().getAllLHSVariables()) {
            startPoint.addItem(v, "va." + v);
        }
        startPoint.setVisibleItemCount(1);
        startPoint.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ListBox lb = (ListBox)event.getSource();
                int index = lb.getSelectedIndex();
                if (index > 0) {
                    ExpressionBuilder.this.onStartPointChange(lb.getValue(index));
                }
            }
        });
        return startPoint;
    }

    private void onStartPointChange(String value) {
        this.setModified(true);
        this.panel.clear();
        int dotPos = value.indexOf(46);
        String prefix = value.substring(0, dotPos);
        String attrib = value.substring(dotPos + 1);
        if (prefix.equals(VARIABLE_VALUE_PREFIX)) {
            ExpressionVariable variable;
            FactPattern fact = this.getRuleModel().getLHSBoundFact(attrib);
            if (fact != null) {
                variable = new ExpressionVariable(fact.getBoundName(), fact.getFactType());
            } else {
                String lhsBindingType = this.getRuleModel().getLHSBindingType(attrib);
                variable = new ExpressionFieldVariable(attrib, lhsBindingType);
            }
            this.expression.appendPart((ExpressionPart)variable);
            this.onStartPointChangeUpdateWidget();
        } else if (prefix.equals(GLOBAL_VARIABLE_VALUE_PREFIX)) {
            ExpressionPartHelper.getExpressionPartForGlobalVariable(this.getDataModelOracle(), attrib, new Callback<ExpressionPart>(){

                public void callback(ExpressionPart part) {
                    ExpressionBuilder.this.expression.appendPart(part);
                    ExpressionBuilder.this.onStartPointChangeUpdateWidget();
                }
            });
        }
    }

    private void onStartPointChangeUpdateWidget() {
        this.initializeWidgets();
        this.fireExpressionChangeEvent();
        this.fireExpressionTypeChangeEvent();
    }

    private Widget getWidgetForCurrentType() {
        if (this.isExpressionEmpty()) {
            return this.createStartPointWidget();
        }
        final ChangeHandler changeHandler = new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ListBox box = (ListBox)event.getSource();
                ExpressionBuilder.this.panel.remove((Widget)box);
                if (box.getSelectedIndex() > 0) {
                    ExpressionBuilder.this.onChangeSelection(box.getValue(box.getSelectedIndex()));
                }
            }
        };
        final ListBox listBox = new ListBox();
        listBox.addItem(GuidedRuleEditorResources.CONSTANTS.Choose(), "");
        if (this.includeDeleteOption()) {
            listBox.addItem("<==" + GuidedRuleEditorResources.CONSTANTS.DeleteItem(), DELETE_VALUE);
        }
        listBox.addItem("-- Text --", TEXT_VALUE);
        this.getCompletionsForCurrentType(this.expression.getParts().size() > 1, new Callback<Map<String, String>>(){

            public void callback(Map<String, String> completions) {
                for (Map.Entry<String, String> entry : completions.entrySet()) {
                    listBox.addItem(entry.getKey(), entry.getValue());
                }
                listBox.addChangeHandler(changeHandler);
            }
        });
        return listBox;
    }

    private boolean includeDeleteOption() {
        if (this.expression.getParts().size() == 0) {
            return false;
        }
        return this.expression.getParts().size() != 1 || !(this.expression.getParts().get(0) instanceof ExpressionUnboundFact);
    }

    private void onChangeSelection(String value) {
        this.setModified(true);
        String prevFactName = null;
        final String oldType = this.getCurrentGenericType();
        if (DELETE_VALUE.equals(value)) {
            this.expression.removeLast();
            this.onChangeSelectionUpdateExpressionWidget(oldType);
        } else if (TEXT_VALUE.equals(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionText(""));
            this.onChangeSelectionUpdateExpressionWidget(oldType);
        } else {
            int dotPos = value.indexOf(46);
            String prefix = value.substring(0, dotPos);
            String attrib = value.substring(dotPos + 1);
            prevFactName = this.getDataModelOracle().getFactNameFromType(this.getCurrentClassType());
            if (FIElD_VALUE_PREFIX.equals(prefix)) {
                ExpressionPartHelper.getExpressionPartForField(this.getDataModelOracle(), prevFactName, attrib, new Callback<ExpressionPart>(){

                    public void callback(ExpressionPart part) {
                        ExpressionBuilder.this.expression.appendPart(part);
                        ExpressionBuilder.this.onChangeSelectionUpdateExpressionWidget(oldType);
                    }
                });
            } else if (METHOD_VALUE_PREFIX.equals(prefix)) {
                ExpressionPartHelper.getExpressionPartForMethod(this.getDataModelOracle(), prevFactName, attrib, new Callback<ExpressionPart>(){

                    public void callback(ExpressionPart part) {
                        ExpressionBuilder.this.expression.appendPart(part);
                        ExpressionBuilder.this.onChangeSelectionUpdateExpressionWidget(oldType);
                    }
                });
            }
        }
    }

    private void onChangeSelectionUpdateExpressionWidget(String oldType) {
        this.initializeWidgets();
        this.fireExpressionChangeEvent();
        this.fireExpressionTypeChangeEvent(oldType);
    }

    private void getCompletionsForCurrentType(boolean isNested, Callback<Map<String, String>> callback) {
        if ("FinalObject".equals(this.getCurrentGenericType())) {
            callback.callback((Object)Collections.EMPTY_MAP);
            return;
        }
        String factName = this.getDataModelOracle().getFactNameFromType(this.getCurrentClassType());
        if (factName != null) {
            this.getMethods(isNested, callback, factName);
        } else {
            callback.callback((Object)Collections.EMPTY_MAP);
        }
    }

    private void getMethods(final boolean isNested, final Callback<Map<String, String>> callback, final String factName) {
        this.getDataModelOracle().getMethodInfos(factName, (Callback)new Callback<List<MethodInfo>>(){

            public void callback(List<MethodInfo> methodInfos) {
                ExpressionBuilder.this.fillMethods(methodInfos, factName, isNested, (Callback<Map<String, String>>)callback);
            }
        });
    }

    private void fillMethods(final List<MethodInfo> methodInfos, String factName, final boolean isNested, final Callback<Map<String, String>> callback) {
        this.getDataModelOracle().getFieldCompletions(factName, FieldAccessorsAndMutators.ACCESSOR, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                TreeMap<String, String> completions = new TreeMap<String, String>();
                for (ModelField field : fields) {
                    String fieldName = field.getName();
                    if (isNested && fieldName.equals("this")) continue;
                    completions.put(fieldName, "fl." + fieldName);
                }
                for (MethodInfo methodInfo : methodInfos) {
                    if (methodInfo.getGenericType().equals("void")) continue;
                    String methodNameWithParams = methodInfo.getNameWithParameters();
                    completions.put(methodNameWithParams, "mt." + methodNameWithParams);
                }
                callback.callback(completions);
            }
        });
    }

    private RuleModel getRuleModel() {
        return this.getModeller().getModel();
    }

    private AsyncPackageDataModelOracle getDataModelOracle() {
        return this.getModeller().getDataModelOracle();
    }

    private String getCurrentClassType() {
        return this.expression.getClassType();
    }

    private String getCurrentGenericType() {
        if (this.expression.getParts().isEmpty()) {
            return null;
        }
        if (this.expression.getParts().get(this.expression.getParts().size() - 1) instanceof ExpressionText) {
            return "FinalObject";
        }
        return this.expression.getGenericType();
    }

    private String getPreviousGenericType() {
        return this.expression.getPreviousGenericType();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    @Override
    public HandlerRegistration addExpressionTypeChangeHandler(ExpressionTypeChangeHandler handler) {
        return this.addHandler(handler, ExpressionTypeChangeEvent.getType());
    }

    private void fireExpressionChangeEvent() {
        this.fireEvent(new ExpressionChangeEvent());
    }

    private void fireExpressionTypeChangeEvent() {
        this.fireExpressionTypeChangeEvent(this.getPreviousGenericType());
    }

    private void fireExpressionTypeChangeEvent(String previousGenericType) {
        String currentGenericType = this.getCurrentGenericType();
        if (previousGenericType == null || !previousGenericType.equals(currentGenericType) || currentGenericType != null) {
            this.fireEvent(new ExpressionTypeChangeEvent(previousGenericType, currentGenericType));
        }
    }

    @Override
    public HandlerRegistration addExpressionChangeHandler(ExpressionChangeHandler handler) {
        return this.addHandler(handler, ExpressionChangeEvent.getType());
    }

    private void showBindingPopUp() {
        final FormStylePopup popup = new FormStylePopup(GuidedRuleEditorResources.CONSTANTS.ExpressionEditor());
        final TextBox varName = new TextBox();
        if (this.expression.isBound()) {
            varName.setText(this.expression.getBinding());
        }
        popup.addAttribute(GuidedRuleEditorResources.CONSTANTS.BindTheExpressionToAVariable(), (IsWidget)new InputGroup(){
            {
                this.add((Widget)varName);
                this.add((Widget)new InputGroupButton(){
                    {
                        this.add((Widget)new Button(HumanReadableConstants.INSTANCE.Set()){
                            {
                                this.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        String var = varName.getText();
                                        if (ExpressionBuilder.this.getModeller().isVariableNameUsed(var)) {
                                            Window.alert((String)GuidedRuleEditorResources.CONSTANTS.TheVariableName0IsAlreadyTaken(var));
                                            return;
                                        }
                                        ExpressionBuilder.this.expression.setBinding(var);
                                        ExpressionBuilder.this.getModeller().refreshWidget();
                                        popup.hide();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        popup.show();
    }

    private ClickableLabel createBindingWidgetForExpression(String text) {
        ClickableLabel label = new ClickableLabel(text, (ClickHandler)this.slch, !this.readOnly);
        return label;
    }

    private Widget createWidgetForExpression() {
        HorizontalPanel container = new HorizontalPanel();
        container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        container.setStylePrimaryName(GuidedRuleEditorResources.INSTANCE.css().container());
        for (ExpressionPart expressionPart : this.expression.getParts()) {
            if (expressionPart instanceof ExpressionUnboundFact) continue;
            if (this.readOnly) {
                container.add((Widget)new Label(expressionPart.getName()));
            } else if (expressionPart instanceof ExpressionMethod) {
                container.add((Widget)new Label(expressionPart.getName()));
                container.add((Widget)new Label("("));
                ExpressionMethod em = (ExpressionMethod)expressionPart;
                List emParams = em.getOrderedParams();
                for (int index = 0; index < emParams.size(); ++index) {
                    ExpressionFormLine paramValueHolder = (ExpressionFormLine)emParams.get(index);
                    String paramDataType = em.getParameterDataType(paramValueHolder);
                    final ExpressionMethodParameter paramValue = (ExpressionMethodParameter)paramValueHolder.getRootExpression();
                    TextBox paramValueEditor = TextBoxFactory.getTextBox((String)paramDataType);
                    paramValueEditor.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                        public void onValueChange(ValueChangeEvent<String> event) {
                            paramValue.setText((String)event.getValue());
                        }
                    });
                    paramValueEditor.setText(paramValue.getName());
                    container.add((Widget)paramValueEditor);
                    if (index >= emParams.size() - 1) continue;
                    container.add((Widget)new Label(", "));
                }
                container.add((Widget)new Label(")"));
            } else if (!(expressionPart instanceof ExpressionText)) {
                container.add((Widget)new Label(expressionPart.getName()));
            } else {
                final TextBox tb = new TextBox();
                final ExpressionText expressionTextPart = (ExpressionText)expressionPart;
                tb.setText(expressionTextPart.getName());
                tb.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent changeEvent) {
                        expressionTextPart.setText(tb.getText());
                    }
                });
                container.add((Widget)tb);
            }
            container.add((Widget)new Label("."));
        }
        return container;
    }

    private class SmallLabelClickHandler
    implements ClickHandler {
        private SmallLabelClickHandler() {
        }

        public void onClick(ClickEvent event) {
            ExpressionBuilder.this.showBindingPopUp();
        }
    }
}

