/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget.attribute;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.EditAttributeWidgetFactory;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.widget.LiteralTextBox;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.NumericLongTextBox;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={NumericLongTextBox.class, LiteralTextBox.class, DatePicker.class, DateTimeFormat.class})
public class EditAttributeWidgetFactoryTest {
    private boolean isReadOnly = false;
    @Mock
    private RuleAttribute ruleAttribute;
    @Captor
    private ArgumentCaptor<ValueChangeHandler> valueChangeHandlerArgumentCaptor;
    EditAttributeWidgetFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = (EditAttributeWidgetFactory)Mockito.spy((Object)new EditAttributeWidgetFactory(this.isReadOnly));
    }

    @Test
    public void testLiteralEditBox() {
        TextBox textBox = this.factory.textBox(this.ruleAttribute, "String");
        Assertions.assertThat((Object)textBox).isInstanceOf(LiteralTextBox.class);
        ((EditAttributeWidgetFactory)Mockito.verify((Object)this.factory)).initTextBoxByRuleAttribute(textBox, this.ruleAttribute);
    }

    @Test
    public void testNumericLongEditBox() {
        TextBox textBox = this.factory.textBox(this.ruleAttribute, "Long");
        Assertions.assertThat((Object)textBox).isInstanceOf(NumericLongTextBox.class);
        ((EditAttributeWidgetFactory)Mockito.verify((Object)this.factory)).initTextBoxByRuleAttribute(textBox, this.ruleAttribute);
    }

    @Test
    public void testDatePicker() {
        DatePicker picker = this.factory.datePicker(this.ruleAttribute, false);
        ((EditAttributeWidgetFactory)Mockito.verify((Object)this.factory)).initDatePickerByRuleAttribute(picker, this.ruleAttribute);
    }

    @Test
    public void testInitTextBoxByRuleAttribute() {
        TextBox textBox = (TextBox)Mockito.mock(TextBox.class);
        String attributeValue = "123";
        ((RuleAttribute)Mockito.doReturn((Object)"123").when((Object)this.ruleAttribute)).getValue();
        this.factory.initTextBoxByRuleAttribute(textBox, this.ruleAttribute);
        ((TextBox)Mockito.verify((Object)textBox)).setEnabled(!this.isReadOnly);
        ((TextBox)Mockito.verify((Object)textBox)).setValue((Object)"123");
    }

    @Test
    public void testTextBoxValueChangeHandler() {
        TextBox textBox = (TextBox)Mockito.mock(TextBox.class);
        String textBoxValue = "123";
        ((TextBox)Mockito.doReturn((Object)"123").when((Object)textBox)).getValue();
        this.factory.initTextBoxByRuleAttribute(textBox, this.ruleAttribute);
        ((TextBox)Mockito.verify((Object)textBox)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerArgumentCaptor.capture());
        ((ValueChangeHandler)this.valueChangeHandlerArgumentCaptor.getValue()).onValueChange(null);
        ((RuleAttribute)Mockito.verify((Object)this.ruleAttribute)).setValue("123");
    }

    @Test
    public void testInitDatePickerByRuleAttribute() {
        DatePicker datePicker = (DatePicker)Mockito.mock(DatePicker.class);
        String attributeValue = "31-May-2018";
        ((RuleAttribute)Mockito.doReturn((Object)"31-May-2018").when((Object)this.ruleAttribute)).getValue();
        this.factory.initDatePickerByRuleAttribute(datePicker, this.ruleAttribute);
        ((DatePicker)Mockito.verify((Object)datePicker)).setFormat((String)Matchers.any());
        ((DatePicker)Mockito.verify((Object)datePicker)).setValue((Date)Matchers.notNull(Date.class));
    }

    @Test
    public void testDatePickerValueChangeHandler() {
        DatePicker datePicker = (DatePicker)Mockito.mock(DatePicker.class);
        Date datePickerValue = new Date();
        ((DatePicker)Mockito.doReturn((Object)datePickerValue).when((Object)datePicker)).getValue();
        this.factory.initDatePickerByRuleAttribute(datePicker, this.ruleAttribute);
        ((DatePicker)Mockito.verify((Object)datePicker)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerArgumentCaptor.capture());
        ((ValueChangeHandler)this.valueChangeHandlerArgumentCaptor.getValue()).onValueChange(null);
        ((RuleAttribute)Mockito.verify((Object)this.ruleAttribute)).setValue(Matchers.anyString());
    }

    @Test
    public void testDatePickerValueChangeHandlerNullValue() {
        DatePicker datePicker = (DatePicker)Mockito.mock(DatePicker.class);
        Object datePickerValue = null;
        ((DatePicker)Mockito.doReturn(datePickerValue).when((Object)datePicker)).getValue();
        this.factory.initDatePickerByRuleAttribute(datePicker, this.ruleAttribute);
        ((DatePicker)Mockito.verify((Object)datePicker)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerArgumentCaptor.capture());
        ((ValueChangeHandler)this.valueChangeHandlerArgumentCaptor.getValue()).onValueChange(null);
        ((RuleAttribute)Mockito.verify((Object)this.ruleAttribute)).setValue((String)Matchers.eq(null));
    }
}

