/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import java.util.Arrays;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;

public class ConstraintValueChangeHandler
implements ValueChangeHandler<String> {
    private final BaseSingleFieldConstraint constraint;
    private final Command onChangeCommand;

    public ConstraintValueChangeHandler(BaseSingleFieldConstraint constraint, Command onChangeCommand) {
        this.constraint = constraint;
        this.onChangeCommand = onChangeCommand;
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        if (Arrays.asList(OperatorsOracle.EXPLICIT_LIST_OPERATORS).contains(this.constraint.getOperator())) {
            this.constraint.setValue(this.replaceQuotes((String)event.getValue()));
        } else {
            this.constraint.setValue((String)event.getValue());
        }
        if (this.onChangeCommand != null) {
            this.onChangeCommand.execute();
        }
    }

    private String replaceQuotes(String value) {
        return value.replace("\\\\", "\\").replace("\\\"", "\"");
    }
}

