/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor.factPattern;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionUnboundFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.HasConstraints;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.factPattern.PopupCreator;
import org.gwtbootstrap3.client.ui.Button;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

@WithClassesToStub(value={Button.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class PopupCreatorTest {
    private PopupCreator popupCreator;

    @Before
    public void setUp() {
        this.popupCreator = (PopupCreator)Mockito.spy((Object)new PopupCreator());
    }

    @Test
    public void testMakeExpressionEditorButton() {
        HasConstraints hasConstraints = (HasConstraints)Mockito.mock(HasConstraints.class);
        FormStylePopup popup = (FormStylePopup)Mockito.mock(FormStylePopup.class);
        Button button = (Button)Mockito.mock(Button.class);
        ClickHandler clickHandler = (ClickHandler)Mockito.mock(ClickHandler.class);
        ((PopupCreator)Mockito.doReturn((Object)button).when((Object)this.popupCreator)).makeExpressionEditorButton();
        ((PopupCreator)Mockito.doReturn((Object)clickHandler).when((Object)this.popupCreator)).onExpressionEditorButtonClick(hasConstraints, popup);
        this.popupCreator.makeExpressionEditorButton(hasConstraints, popup);
        ((Button)Mockito.verify((Object)button)).addClickHandler(clickHandler);
    }

    @Test
    public void testOnExpressionEditorButtonClick() {
        String factType = "factType";
        FactPattern factPattern = (FactPattern)Mockito.mock(FactPattern.class);
        HasConstraints hasConstraints = (HasConstraints)Mockito.mock(HasConstraints.class);
        FormStylePopup popup = (FormStylePopup)Mockito.mock(FormStylePopup.class);
        SingleFieldConstraintEBLeftSide constraint = (SingleFieldConstraintEBLeftSide)Mockito.mock(SingleFieldConstraintEBLeftSide.class);
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        ClickEvent clickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((FactPattern)Mockito.doReturn((Object)"factType").when((Object)factPattern)).getFactType();
        ((PopupCreator)Mockito.doReturn((Object)constraint).when((Object)this.popupCreator)).makeSingleFieldConstraintEBLeftSide("factType");
        ((PopupCreator)Mockito.doReturn((Object)ruleModeller).when((Object)this.popupCreator)).getModeller();
        ((PopupCreator)Mockito.doReturn((Object)factPattern).when((Object)this.popupCreator)).getPattern();
        ClickHandler clickHandler = this.popupCreator.onExpressionEditorButtonClick(hasConstraints, popup);
        clickHandler.onClick(clickEvent);
        ((HasConstraints)Mockito.verify((Object)hasConstraints)).addConstraint((FieldConstraint)constraint);
        ((RuleModeller)Mockito.verify((Object)ruleModeller)).refreshWidget();
        ((FormStylePopup)Mockito.verify((Object)popup)).hide();
    }

    @Test
    public void testMakeSingleFieldConstraintEBLeftSide() {
        String expectedFactType = "factType";
        ExpressionFormLine expectedExpressionFormLine = (ExpressionFormLine)Mockito.mock(ExpressionFormLine.class);
        boolean expectedConstraintValueType = false;
        ((PopupCreator)Mockito.doReturn((Object)expectedExpressionFormLine).when((Object)this.popupCreator)).makeExpressionFormLine("factType");
        SingleFieldConstraintEBLeftSide constraint = this.popupCreator.makeSingleFieldConstraintEBLeftSide("factType");
        Assert.assertEquals((long)0L, (long)constraint.getConstraintValueType());
        Assert.assertEquals((Object)expectedExpressionFormLine, (Object)constraint.getExpressionLeftSide());
        Assert.assertEquals((Object)"factType", (Object)constraint.getFactType());
    }

    @Test
    public void testMakeExpressionFormLine() {
        String expectedFactType = "factType";
        ExpressionFormLine expressionFormLine = this.popupCreator.makeExpressionFormLine("factType");
        Assert.assertEquals((long)1L, (long)this.size(expressionFormLine));
        Assert.assertEquals((Object)"factType", (Object)this.first(expressionFormLine).getFactType());
    }

    private ExpressionUnboundFact first(ExpressionFormLine expressionFormLine) {
        ExpressionPart firstPart = (ExpressionPart)expressionFormLine.getParts().get(0);
        return (ExpressionUnboundFact)firstPart;
    }

    private int size(ExpressionFormLine expressionFormLine) {
        List parts = expressionFormLine.getParts();
        return parts.size();
    }
}

