/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.GuidedRuleEditorPresenter;
import org.drools.workbench.screens.guided.rule.client.editor.GuidedRuleEditorView;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.drools.workbench.screens.guided.rule.model.GuidedEditorContent;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.mocks.CallerMock;

@WithClassesToStub(value={Text.class, BaseModal.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedRuleEditorPresenterTest {
    private GuidedEditorContent guidedEditorContent;
    @Mock
    private KieEditorWrapperView kieEditorWrapperView;
    @Mock
    private OverviewWidgetPresenter overviewWidgetPresenter;
    @Mock
    private ManagedInstance<RuleModellerActionPlugin> actionPluginInstance;
    @Mock
    private ImportsWidgetPresenter importsWidgetPresenter;
    @Mock
    private AsyncPackageDataModelOracleFactory oracleFactory;
    @Mock
    private GuidedRuleEditorView view;
    @Mock
    private ObservablePath resourcePath;
    @Mock
    private VersionRecordManager versionRecordManager;
    @Mock
    private GuidedRuleEditorService service;
    private CallerMock<GuidedRuleEditorService> serviceCaller;
    @Mock
    private RuleNamesService ruleNamesService;
    private CallerMock<RuleNamesService> ruleNamesServiceCaller;
    @Mock
    private RuleModel ruleModel;
    @Mock
    private Imports imports;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private PackageDataModelOracleBaselinePayload payload;
    @Mock
    private Overview overview;
    @Spy
    @InjectMocks
    private GuidedRuleEditorPresenter presenter;
    @Captor
    private ArgumentCaptor<List<RuleModellerActionPlugin>> pluginsListCaptor;

    public GuidedRuleEditorPresenterTest() {
        this.presenter = new GuidedRuleEditorPresenter(this.view);
    }

    @Before
    public void setUp() throws Exception {
        this.guidedEditorContent = new GuidedEditorContent(this.ruleModel, this.overview, this.payload);
        this.serviceCaller = new CallerMock((Object)this.service);
        this.ruleNamesServiceCaller = new CallerMock((Object)this.ruleNamesService);
        ((RuleModel)Mockito.doReturn((Object)this.imports).when((Object)this.ruleModel)).getImports();
        ((AsyncPackageDataModelOracleFactory)Mockito.doReturn((Object)this.oracle).when((Object)this.oracleFactory)).makeAsyncPackageDataModelOracle((Path)this.resourcePath, (HasImports)this.ruleModel, this.payload);
        ((VersionRecordManager)Mockito.doReturn((Object)this.resourcePath).when((Object)this.versionRecordManager)).getCurrentPath();
        ((VersionRecordManager)Mockito.doReturn((Object)this.resourcePath).when((Object)this.versionRecordManager)).getPathToLatest();
        ((GuidedRuleEditorService)Mockito.doReturn((Object)this.guidedEditorContent).when((Object)this.service)).loadContent((Path)this.resourcePath);
        ((GuidedRuleEditorPresenter)Mockito.doReturn(this.serviceCaller).when((Object)this.presenter)).getService();
        ((GuidedRuleEditorPresenter)Mockito.doReturn(this.ruleNamesServiceCaller).when((Object)this.presenter)).getRuleNamesService();
        ((GuidedRuleEditorPresenter)Mockito.doReturn((Object)this.versionRecordManager).when((Object)this.presenter)).getVersionRecordManager();
    }

    @Test
    public void testLoadContentSuccess() throws Exception {
        RuleModellerActionPlugin pluginOne = (RuleModellerActionPlugin)Mockito.mock(RuleModellerActionPlugin.class);
        RuleModellerActionPlugin pluginTwo = (RuleModellerActionPlugin)Mockito.mock(RuleModellerActionPlugin.class);
        ((ManagedInstance)Mockito.doAnswer(invocationOnMock -> {
            Consumer consumer = (Consumer)invocationOnMock.getArgument(0, Consumer.class);
            consumer.accept(pluginOne);
            consumer.accept(pluginTwo);
            return null;
        }).when(this.actionPluginInstance)).forEach((Consumer)Matchers.any());
        this.presenter.loadContent();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).clear();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addMainEditorPage((IsWidget)this.view);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addOverviewPage((OverviewWidgetPresenter)Matchers.any(), (Command)Matchers.any());
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addImportsTab((IsWidget)Matchers.eq((Object)this.importsWidgetPresenter));
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addSourcePage((ViewDRLSourceWidget)Matchers.any());
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory)).makeAsyncPackageDataModelOracle((Path)this.resourcePath, (HasImports)this.ruleModel, this.payload);
        ((OverviewWidgetPresenter)Mockito.verify((Object)this.overviewWidgetPresenter)).setContent(this.overview, this.resourcePath);
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidgetPresenter)).setContent(this.oracle, this.imports, false);
        ((GuidedRuleEditorView)Mockito.verify((Object)this.view)).hideBusyIndicator();
        ((GuidedRuleEditorView)Mockito.verify((Object)this.view)).setContent((RuleModel)Matchers.eq((Object)this.ruleModel), (Collection)this.pluginsListCaptor.capture(), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle), (Caller)Matchers.eq(this.ruleNamesServiceCaller), Matchers.eq((boolean)false), Matchers.eq((boolean)false));
        Assertions.assertThat((List)((List)this.pluginsListCaptor.getValue())).containsExactly((Object[])new RuleModellerActionPlugin[]{pluginOne, pluginTwo});
    }

    @Test
    public void testLoadContentFail() throws Exception {
        ((GuidedRuleEditorService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.service)).loadContent((Path)this.resourcePath);
        this.presenter.loadContent();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.never())).clear();
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.never())).addMainEditorPage((IsWidget)this.view);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.never())).addOverviewPage((OverviewWidgetPresenter)Matchers.any(), (Command)Matchers.any());
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.never())).addImportsTab((IsWidget)Matchers.any());
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.never())).addSourcePage((ViewDRLSourceWidget)Matchers.any());
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.never())).makeAsyncPackageDataModelOracle((Path)this.resourcePath, (HasImports)this.ruleModel, this.payload);
        ((OverviewWidgetPresenter)Mockito.verify((Object)this.overviewWidgetPresenter, (VerificationMode)Mockito.never())).setContent(this.overview, this.resourcePath);
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidgetPresenter, (VerificationMode)Mockito.never())).setContent(this.oracle, this.imports, false);
        ((GuidedRuleEditorView)Mockito.verify((Object)this.view)).hideBusyIndicator();
    }

    @Test
    public void testGetContentSupplier() throws Exception {
        RuleModel content = (RuleModel)Mockito.mock(RuleModel.class);
        ((GuidedRuleEditorView)Mockito.doReturn((Object)content).when((Object)this.view)).getContent();
        Supplier contentSupplier = this.presenter.getContentSupplier();
        Assert.assertEquals((Object)content, contentSupplier.get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() throws Exception {
        Caller serviceCaller = this.presenter.getSaveAndRenameServiceCaller();
        Assert.assertEquals(this.serviceCaller, (Object)serviceCaller);
    }
}

