/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.widget;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.DSLVariableValue;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.widget.DSLSentenceWidget;
import org.drools.workbench.screens.guided.rule.client.widget.EnumDropDown;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.DropDownValueChanged;

public class DSLDropDown
extends Composite
implements DSLSentenceWidget.DSLVariableEditor {
    private RuleModeller ruleModeller;
    private AsyncPackageDataModelOracle oracle;
    private EnumDropDown resultWidget = null;
    private String factType;
    private String factField;
    private DSLSentence dslSentence;
    private DSLVariableValue selectedValue;
    private Callback<DSLDropDown> updateEnumDropDownsCallback;

    public DSLDropDown(RuleModeller ruleModeller, String variableDef, DSLSentence dslSentence, DSLVariableValue value, boolean multipleSelect, final Callback<DSLDropDown> updateEnumDropDownsCallback) {
        this.ruleModeller = ruleModeller;
        this.oracle = ruleModeller.getDataModelOracle();
        this.dslSentence = dslSentence;
        this.updateEnumDropDownsCallback = updateEnumDropDownsCallback;
        int lastIndex = variableDef.lastIndexOf(":");
        String factAndField = variableDef.substring(lastIndex + 1, variableDef.length());
        int dotIndex = factAndField.indexOf(".");
        this.factType = factAndField.substring(0, dotIndex);
        this.factField = factAndField.substring(dotIndex + 1, factAndField.length());
        this.selectedValue = value;
        DropDownValueChanged handler = new DropDownValueChanged(){

            public void valueChanged(String newText, String newValue) {
                if (DSLDropDown.this.selectedValue.getValue().equals(newValue)) {
                    return;
                }
                DSLDropDown.this.selectedValue = new DSLVariableValue(newValue);
                updateEnumDropDownsCallback.callback((Object)DSLDropDown.this);
            }
        };
        DropDownData dropDownData = this.getDropDownData();
        this.resultWidget = new EnumDropDown(value.getValue(), handler, dropDownData, multipleSelect, ruleModeller.getPath());
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new HTML("&nbsp;"));
        hp.add((Widget)this.resultWidget);
        hp.add((Widget)new HTML("&nbsp;"));
        this.initWidget((Widget)hp);
    }

    @Override
    public DSLVariableValue getSelectedValue() {
        return this.selectedValue;
    }

    public void refreshDropDownData() {
        this.resultWidget.setDropDownData(this.selectedValue.getValue(), this.getDropDownData());
    }

    DropDownData getDropDownData() {
        DropDownData dropDownData = this.oracle.getEnums(this.factType, this.factField, this.dslSentence.getEnumFieldValueMap());
        return dropDownData;
    }
}

