/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerActionSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

@WithClassesToStub(value={Heading.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class RuleModellerActionSelectorPopupTest {
    @Mock
    private RuleModeller ruleModeller;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private RuleModellerActionPlugin actionPlugin;
    @Mock
    private IAction iAction;
    @Mock
    private ListBox listBox;
    @Captor
    private ArgumentCaptor<Command> commandArgumentCaptor;
    private RuleModel model;
    private RuleModellerActionSelectorPopup popup;

    @Before
    public void setUp() {
        GwtMockito.useProviderForType(ListBox.class, aClass -> this.listBox);
        this.model = (RuleModel)Mockito.spy((Object)new RuleModel());
        Mockito.when((Object)this.oracle.getDSLConditions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.oracle.getFactTypes()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.oracle.getGlobalVariables()).thenReturn((Object)new String[0]);
        this.popup = (RuleModellerActionSelectorPopup)Mockito.spy((Object)new RuleModellerActionSelectorPopup(this.model, this.ruleModeller, Collections.singletonList(this.actionPlugin), null, this.oracle));
        Mockito.reset((Object[])new RuleModel[]{this.model});
    }

    @Test
    public void checkAddUpdateNotModifyGetsPatternBindings() {
        this.popup.addUpdateNotModify();
        ((RuleModel)Mockito.verify((Object)this.model)).getLHSPatternVariables();
    }

    @Test
    public void checkAddRetractionsGetsPatternBindings() {
        this.popup.addRetractions();
        ((RuleModel)Mockito.verify((Object)this.model)).getLHSPatternVariables();
    }

    @Test
    public void checkAddModifiesGetsLhsBindings() {
        this.popup.addModifies();
        ((RuleModel)Mockito.verify((Object)this.model)).getAllLHSVariables();
    }

    @Test
    public void checkAddCallMethodOnGetsAllBindings() {
        this.popup.addCallMethodOn();
        ((RuleModel)Mockito.verify((Object)this.model)).getAllLHSVariables();
        ((RuleModel)Mockito.verify((Object)this.model)).getRHSBoundFacts();
    }

    @Test
    public void testActionPlugins() throws Exception {
        Mockito.reset((Object[])new RuleModellerActionPlugin[]{this.actionPlugin});
        String actionDescription = "modify score";
        String actionId = "modify score id";
        ((RuleModellerActionPlugin)Mockito.doReturn((Object)"modify score").when((Object)this.actionPlugin)).getActionAddDescription();
        ((RuleModellerActionPlugin)Mockito.doReturn((Object)"modify score id").when((Object)this.actionPlugin)).getId();
        ((RuleModellerActionPlugin)Mockito.doReturn((Object)this.iAction).when((Object)this.actionPlugin)).createIAction((RuleModeller)Matchers.eq((Object)this.ruleModeller));
        this.popup.getContent();
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).createIAction(this.ruleModeller);
        ((RuleModellerActionPlugin)Mockito.verify((Object)this.actionPlugin)).addPluginToActionList((RuleModeller)Matchers.eq((Object)this.ruleModeller), (Command)this.commandArgumentCaptor.capture());
        Mockito.reset((Object[])new ListBox[]{this.listBox});
        ((Command)this.commandArgumentCaptor.getValue()).execute();
        ((ListBox)Mockito.verify((Object)this.listBox)).addItem((String)Matchers.eq((Object)"modify score"), (String)Matchers.eq((Object)"modify score id"));
        Assertions.assertThat((Map)this.popup.cmds).containsKeys((Object[])new String[]{"modify score id"});
        Mockito.reset((Object[])new ListBox[]{this.listBox});
        ((ListBox)Mockito.doReturn((Object)"123").when((Object)this.listBox)).getValue(Matchers.anyInt());
        ((com.google.gwt.user.client.Command)this.popup.cmds.get("modify score id")).execute();
        ((RuleModel)Mockito.verify((Object)this.model)).addRhsItem(this.iAction, 123);
        ((RuleModellerActionSelectorPopup)Mockito.verify((Object)this.popup)).hide();
    }
}

