/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import java.util.function.Predicate;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromEntryPointFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.AbstractRuleModellerSelectorPopup;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerSelectorFilter;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class RuleModellerConditionSelectorPopup
extends AbstractRuleModellerSelectorPopup {
    private final Command okCommand = new Command(){

        public void execute() {
            RuleModellerConditionSelectorPopup.this.selectSomething();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            RuleModellerConditionSelectorPopup.this.hide();
        }
    };

    public RuleModellerConditionSelectorPopup(RuleModel model, RuleModeller ruleModeller, Integer position, AsyncPackageDataModelOracle oracle) {
        super(model, ruleModeller, position, oracle);
        this.add((Widget)new ModalBody(){
            {
                this.add(RuleModellerConditionSelectorPopup.this.getContent());
            }
        });
        this.add((Widget)new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand));
    }

    @Override
    protected String getPopupTitle() {
        return GuidedRuleEditorResources.CONSTANTS.AddAConditionToTheRule();
    }

    @Override
    public Widget getContent() {
        if (this.position == null) {
            this.positionCbo.addItem(GuidedRuleEditorResources.CONSTANTS.Bottom(), String.valueOf(this.model.lhs.length));
            this.positionCbo.addItem(GuidedRuleEditorResources.CONSTANTS.Top(), "0");
            for (int i = 1; i < this.model.lhs.length; ++i) {
                this.positionCbo.addItem(GuidedRuleEditorResources.CONSTANTS.Line0(i), String.valueOf(i));
            }
        } else {
            this.positionCbo.addItem(String.valueOf(this.position));
            this.positionCbo.setSelectedIndex(0);
        }
        if (this.oracle.getDSLConditions().size() == 0 && this.oracle.getFactTypes().length == 0) {
            this.layoutPanel.addRow((IsWidget)new HTML("<div class='highlight'>" + GuidedRuleEditorResources.CONSTANTS.NoModelTip() + "</div>"));
        }
        if (this.position == null) {
            HorizontalPanel hp0 = new HorizontalPanel();
            hp0.add((Widget)new HTML(GuidedRuleEditorResources.CONSTANTS.PositionColon()));
            hp0.add((Widget)this.positionCbo);
            hp0.add((IsWidget)new InfoPopup(GuidedRuleEditorResources.CONSTANTS.PositionColon(), GuidedRuleEditorResources.CONSTANTS.ConditionPositionExplanation()));
            this.layoutPanel.addRow((IsWidget)hp0);
            this.layoutPanel.addRow((IsWidget)new HTML("<hr/>"));
        }
        final RuleModellerSelectorFilter filterWidget = (RuleModellerSelectorFilter)((Object)GWT.create(RuleModellerSelectorFilter.class));
        filterWidget.setFilterChangeConsumer(filter -> this.choicesPanel.setWidget((Widget)this.makeChoicesListBox((String)filter)));
        this.layoutPanel.add((Widget)filterWidget);
        this.choices = this.makeChoicesListBox(filterWidget.getFilterText());
        this.choicesPanel.add((Widget)this.choices);
        this.layoutPanel.addRow((IsWidget)this.choicesPanel);
        if (this.ruleModeller.isDSLEnabled()) {
            CheckBox chkOnlyDisplayDSLConditions = new CheckBox();
            chkOnlyDisplayDSLConditions.setText(GuidedRuleEditorResources.CONSTANTS.OnlyDisplayDSLConditions());
            chkOnlyDisplayDSLConditions.setValue(Boolean.valueOf(this.onlyShowDSLStatements));
            chkOnlyDisplayDSLConditions.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    RuleModellerConditionSelectorPopup.this.onlyShowDSLStatements = (Boolean)event.getValue();
                    RuleModellerConditionSelectorPopup.this.choicesPanel.setWidget((Widget)RuleModellerConditionSelectorPopup.this.makeChoicesListBox(filterWidget.getFilterText()));
                }
            });
            this.layoutPanel.addRow((IsWidget)chkOnlyDisplayDSLConditions);
        }
        return this.layoutPanel;
    }

    public void show() {
        super.show();
        this.choices.setFocus(true);
    }

    private ListBox makeChoicesListBox(String filter) {
        this.choices = (ListBox)GWT.create(ListBox.class);
        this.choices.setMultipleSelect(true);
        this.choices.setPixelSize(this.getChoicesWidth(), this.getChoicesHeight());
        this.choices.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    RuleModellerConditionSelectorPopup.this.selectSomething();
                }
            }
        });
        Predicate<String> predicate = item -> item.toLowerCase().contains(Objects.isNull(filter) ? "" : filter.toLowerCase());
        boolean itemsAdded = this.addDSLSentences(predicate);
        if (!this.onlyShowDSLStatements) {
            itemsAdded = this.addFacts(predicate, itemsAdded) || itemsAdded;
            this.addExistentialConditionalElements(itemsAdded);
            this.addFromConditionalElements();
            this.addFreeFormDrl();
        }
        return this.choices;
    }

    private boolean addDSLSentences(Predicate<String> predicate) {
        boolean moreItemsAdded = false;
        if (this.ruleModeller.isDSLEnabled()) {
            for (final DSLSentence sen : this.oracle.getDSLConditions()) {
                String sentence = sen.toString();
                if (!predicate.test(sentence)) continue;
                String key = "DSL" + sentence;
                this.choices.addItem(sentence, key);
                this.cmds.put(key, new Command(){

                    public void execute() {
                        RuleModellerConditionSelectorPopup.this.addNewDSLLhs(sen, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerConditionSelectorPopup.this.hide();
                    }
                });
                moreItemsAdded = true;
            }
        }
        return moreItemsAdded;
    }

    private boolean addFacts(Predicate<String> predicate, boolean previousItemsAdded) {
        boolean moreItemsAdded = false;
        if (this.oracle.getFactTypes().length > 0) {
            if (this.anyItemsMatch(predicate, this.oracle.getFactTypes()) && previousItemsAdded) {
                this.choices.addItem("..................", "..................");
            }
            for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
                final String f = this.oracle.getFactTypes()[i];
                if (!predicate.test(f)) continue;
                String key = "NF" + f;
                this.choices.addItem(f + " ...", key);
                this.cmds.put(key, new Command(){

                    public void execute() {
                        RuleModellerConditionSelectorPopup.this.addNewFact(f, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerConditionSelectorPopup.this.hide();
                    }
                });
                moreItemsAdded = true;
            }
        }
        return moreItemsAdded;
    }

    private void addExistentialConditionalElements(boolean previousItemsAdded) {
        String[] ces = HumanReadable.CONDITIONAL_ELEMENTS;
        if (previousItemsAdded) {
            this.choices.addItem("..................", "..................");
        }
        for (int i = 0; i < ces.length; ++i) {
            final String ce = ces[i];
            String key = "CE" + ce;
            this.choices.addItem(HumanReadable.getCEDisplayName((String)ce) + " ...", key);
            this.cmds.put(key, new Command(){

                public void execute() {
                    RuleModellerConditionSelectorPopup.this.addNewCE(ce, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerConditionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addFromConditionalElements() {
        String[] fces = HumanReadable.FROM_CONDITIONAL_ELEMENTS;
        this.choices.addItem("..................", "..................");
        for (int i = 0; i < fces.length; ++i) {
            final String ce = fces[i];
            String key = "FCE" + ce;
            this.choices.addItem(HumanReadable.getCEDisplayName((String)ce) + " ...", key);
            this.cmds.put(key, new Command(){

                public void execute() {
                    RuleModellerConditionSelectorPopup.this.addNewFCE(ce, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerConditionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addFreeFormDrl() {
        this.choices.addItem("..................", "..................");
        this.choices.addItem(GuidedRuleEditorResources.CONSTANTS.FreeFormDrl(), "FF");
        this.cmds.put("FF", new Command(){

            public void execute() {
                RuleModellerConditionSelectorPopup.this.model.addLhsItem((IPattern)new FreeFormLine(), Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                RuleModellerConditionSelectorPopup.this.hide();
            }
        });
    }

    private void addNewDSLLhs(DSLSentence sentence, int position) {
        this.model.addLhsItem((IPattern)sentence.copy(), position);
    }

    private void addNewFact(String itemText, int position) {
        this.model.addLhsItem((IPattern)new FactPattern(itemText), position);
    }

    private void addNewCE(String s, int position) {
        this.model.addLhsItem((IPattern)new CompositeFactPattern(s), position);
    }

    private void addNewFCE(String type, int position) {
        FromCompositeFactPattern p = null;
        if (type.equals("from")) {
            p = new FromCompositeFactPattern();
        } else if (type.equals("from accumulate")) {
            p = new FromAccumulateCompositeFactPattern();
        } else if (type.equals("from collect")) {
            p = new FromCollectCompositeFactPattern();
        } else if (type.equals("from entry-point")) {
            p = new FromEntryPointFactPattern();
        }
        this.model.addLhsItem((IPattern)p, position);
    }
}

