/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.guided.template.backend.RuleTemplateModelXMLPersistenceImpl;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.server.indexing.GuidedRuleTemplateFactory;
import org.drools.workbench.screens.guided.template.server.indexing.TestGuidedRuleTemplateFileIndexer;
import org.drools.workbench.screens.guided.template.type.GuidedRuleTemplateResourceTypeDefinition;
import org.junit.Test;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGuidedRuleTemplateAttributesTest
extends BaseIndexingTest<GuidedRuleTemplateResourceTypeDefinition> {
    @Test
    public void testIndexGuidedRuleTemplateAttributes() throws IOException, InterruptedException {
        Path path = this.basePath.resolve("template1.template");
        TemplateModel model = GuidedRuleTemplateFactory.makeModelWithAttributes("org.drools.workbench.screens.guided.template.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("org.drools.workbench.screens.guided.template.server.indexing.classes.Applicant"));
                this.add(new Import("org.drools.workbench.screens.guided.template.server.indexing.classes.Mortgage"));
            }
        }, "template1");
        String xml = RuleTemplateModelXMLPersistenceImpl.getInstance().marshal(model);
        this.ioService().write(path, xml, new OpenOption[0]);
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD)).build();
        this.searchFor(index, query, 1, new Path[]{path});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueSharedPartIndexTerm("myRuleFlowGroup", PartType.RULEFLOW_GROUP)).build();
        this.searchFor(index, query, 1, new Path[]{path});
    }

    protected TestIndexer getIndexer() {
        return new TestGuidedRuleTemplateFileIndexer();
    }

    protected GuidedRuleTemplateResourceTypeDefinition getResourceTypeDefinition() {
        return new GuidedRuleTemplateResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

