/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.server;

import java.util.HashMap;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.guided.template.model.GuidedTemplateEditorContent;
import org.drools.workbench.screens.guided.template.server.GuidedRuleTemplateEditorServiceImpl;
import org.drools.workbench.screens.guided.template.type.GuidedRuleTemplateResourceTypeDefinition;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedRuleTemplateEditorServiceImplTest {
    @Mock
    IOService ioService;
    @Mock
    private CopyService copyService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Mock
    private DataModelService dataModelService;
    @Mock
    private GenericValidator genericValidator;
    @Mock
    private GuidedRuleTemplateResourceTypeDefinition resourceTypeDefinition;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private SessionInfo sessionInfo;
    @InjectMocks
    GuidedRuleTemplateEditorServiceImpl service;

    public GuidedRuleTemplateEditorServiceImplTest() {
        this.service = (GuidedRuleTemplateEditorServiceImpl)Mockito.spy((Object)new GuidedRuleTemplateEditorServiceImpl(this.sessionInfo));
    }

    @Test
    public void checkConstructContentPopulateProjectCollectionTypes() {
        Path path = (Path)Mockito.mock(Path.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        PackageDataModelOracle oracle = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://project/src/main/resources/mypackage/rule.template");
        Mockito.when((Object)this.dataModelService.getDataModel((Path)Matchers.any())).thenReturn((Object)oracle);
        Mockito.when((Object)oracle.getPackageGlobals()).thenReturn((Object)new HashMap<String, String>(){
            {
                this.put("number", "java.lang.Number");
                this.put("collection", "java.util.Collection");
            }
        });
        Mockito.when((Object)oracle.getProjectCollectionTypes()).thenReturn((Object)new HashMap<String, Boolean>(){
            {
                this.put("java.util.List", true);
                this.put("java.util.Set", true);
                this.put("java.util.Collection", true);
                this.put("java.util.UnknownCollection", false);
            }
        });
        GuidedTemplateEditorContent content = this.service.constructContent(path, overview);
        Assert.assertEquals((long)3L, (long)content.getDataModel().getCollectionTypes().size());
        Assert.assertTrue((boolean)content.getDataModel().getCollectionTypes().containsKey("java.util.Collection"));
        Assert.assertTrue((boolean)content.getDataModel().getCollectionTypes().containsKey("java.util.List"));
        Assert.assertTrue((boolean)content.getDataModel().getCollectionTypes().containsKey("java.util.Set"));
    }
}

