/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Panel;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellValueFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataColumn;
import org.drools.workbench.screens.guided.template.client.editor.events.SetInternalTemplateDataModelEvent;
import org.drools.workbench.screens.guided.template.client.editor.events.SetTemplateDataEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractDecoratedGridHeaderWidget;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractDecoratedGridSidebarWidget;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractDecoratedGridWidget;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractMergableGridWidget;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.DynamicColumn;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.ResourcesProvider;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.DynamicData;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.SetModelEvent;

public abstract class AbstractDecoratedTemplateDataGridWidget
extends AbstractDecoratedGridWidget<TemplateModel, TemplateDataColumn, String> {
    protected final TemplateDataCellFactory cellFactory;
    protected final TemplateDataCellValueFactory cellValueFactory;

    public AbstractDecoratedTemplateDataGridWidget(ResourcesProvider<TemplateDataColumn> resources, TemplateDataCellFactory cellFactory, TemplateDataCellValueFactory cellValueFactory, EventBus eventBus, Panel mainPanel, Panel bodyPanel, AbstractMergableGridWidget<TemplateModel, TemplateDataColumn> gridWidget, AbstractDecoratedGridHeaderWidget<TemplateModel, TemplateDataColumn> headerWidget, AbstractDecoratedGridSidebarWidget<TemplateModel, TemplateDataColumn> sidebarWidget) {
        super(resources, eventBus, mainPanel, bodyPanel, gridWidget, headerWidget, sidebarWidget);
        if (cellFactory == null) {
            throw new IllegalArgumentException("cellFactory cannot be null");
        }
        if (cellValueFactory == null) {
            throw new IllegalArgumentException("cellValueFactory cannot be null");
        }
        this.cellFactory = cellFactory;
        this.cellValueFactory = cellValueFactory;
        eventBus.addHandler(SetTemplateDataEvent.TYPE, (EventHandler)this);
    }

    public void onSetModel(SetModelEvent<TemplateModel> event) {
        DynamicData data = new DynamicData();
        TemplateModel model = (TemplateModel)event.getModel();
        ArrayList<DynamicColumn<TemplateDataColumn>> columns = new ArrayList<DynamicColumn<TemplateDataColumn>>();
        this.setupInternalModel(model, columns, data);
        SetInternalTemplateDataModelEvent sime = new SetInternalTemplateDataModelEvent(model, data, columns);
        this.eventBus.fireEvent((GwtEvent)sime);
    }

    private void setupInternalModel(TemplateModel model, List<DynamicColumn<TemplateDataColumn>> columns, DynamicData data) {
        InterpolationVariable[] vars = model.getInterpolationVariablesList();
        if (vars.length == 0) {
            return;
        }
        int colIndex = 0;
        String[][] modelData = model.getTableAsArray();
        for (int iRow = 0; iRow < modelData.length; ++iRow) {
            data.addRow();
        }
        for (InterpolationVariable var : vars) {
            TemplateDataColumn col = new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField());
            DynamicColumn column = new DynamicColumn((Object)col, this.cellFactory.getCell(col), colIndex, this.eventBus);
            columns.add((DynamicColumn<TemplateDataColumn>)column);
            data.addColumn(colIndex, this.makeColumnData(modelData, col, colIndex++), true);
        }
    }

    private List<CellValue<? extends Comparable<?>>> makeColumnData(String[][] data, TemplateDataColumn column, int colIndex) {
        int dataSize = data.length;
        ArrayList columnData = new ArrayList(dataSize);
        for (int iRow = 0; iRow < dataSize; ++iRow) {
            String[] row = data[iRow];
            String initialValue = row[colIndex];
            if (initialValue != null && initialValue.equals("")) {
                initialValue = null;
            }
            CellValue<? extends Comparable<?>> cv = this.cellValueFactory.convertModelCellValue(column, initialValue);
            columnData.add(cv);
        }
        return columnData;
    }
}

