/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.rule.client.util.GWTDateConverter;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellValueFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataColumn;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataTableResourcesProvider;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDropDownManager;
import org.drools.workbench.screens.guided.template.client.editor.VerticalDecoratedTemplateDataGridWidget;
import org.drools.workbench.screens.guided.template.client.editor.events.SetTemplateDataEvent;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractDecoratedGridWidget;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.ResourcesProvider;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.CopyRowsEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.PasteRowsEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateModelEvent;

public class TemplateDataTableWidget
extends Composite
implements InsertRowEvent.Handler,
DeleteRowEvent.Handler,
AppendRowEvent.Handler,
CopyRowsEvent.Handler,
PasteRowsEvent.Handler,
UpdateModelEvent.Handler {
    protected TemplateModel model;
    protected AbstractDecoratedGridWidget<TemplateModel, TemplateDataColumn, String> widget;
    protected TemplateDataCellFactory cellFactory;
    protected TemplateDataCellValueFactory cellValueFactory;
    protected TemplateDropDownManager dropDownManager;
    private EventBus eventBus = new SimpleEventBus();
    private List<String[]> copiedRows = new ArrayList<String[]>();
    protected static final ResourcesProvider<TemplateDataColumn> resources = new TemplateDataTableResourcesProvider();

    public TemplateDataTableWidget(TemplateModel model, AsyncPackageDataModelOracle oracle, boolean isReadOnly, EventBus globalEventBus) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        if (oracle == null) {
            throw new IllegalArgumentException("oracle cannot be null");
        }
        if (globalEventBus == null) {
            throw new IllegalArgumentException("globalEventBus cannot be null");
        }
        this.model = model;
        this.dropDownManager = new TemplateDropDownManager(model, oracle);
        this.cellFactory = new TemplateDataCellFactory(oracle, this.dropDownManager, isReadOnly, this.eventBus);
        this.cellValueFactory = new TemplateDataCellValueFactory(model, oracle);
        this.widget = new VerticalDecoratedTemplateDataGridWidget(resources, this.cellFactory, this.cellValueFactory, this.dropDownManager, isReadOnly, this.eventBus);
        TemplateDataCellValueFactory.injectDateConvertor(GWTDateConverter.getInstance());
        this.eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(CopyRowsEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(PasteRowsEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(UpdateModelEvent.TYPE, (EventHandler)this);
        this.initWidget((Widget)this.widget);
        SetTemplateDataEvent sme = new SetTemplateDataEvent(model);
        this.eventBus.fireEvent((GwtEvent)sme);
    }

    public void appendRow() {
        AppendRowEvent are = new AppendRowEvent();
        this.eventBus.fireEvent((GwtEvent)are);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void onDeleteRow(DeleteRowEvent event) {
        this.model.removeRow(event.getIndex());
    }

    public void onCopyRows(CopyRowsEvent event) {
        this.copiedRows.clear();
        for (Integer iRow : event.getRowIndexes()) {
            String[] rowData = this.model.getTableAsArray()[iRow];
            this.copiedRows.add(rowData);
        }
    }

    public void onPasteRows(PasteRowsEvent event) {
        if (this.copiedRows == null || this.copiedRows.size() == 0) {
            return;
        }
        int iRow = event.getTargetRowIndex();
        for (String[] sourceRowData : this.copiedRows) {
            String[] rowData = this.cellValueFactory.makeRowData().toArray(new String[0]);
            for (int iCol = 0; iCol < sourceRowData.length; ++iCol) {
                rowData[iCol] = sourceRowData[iCol];
            }
            this.model.addRow(iRow, rowData);
            ++iRow;
        }
    }

    public void onInsertRow(InsertRowEvent event) {
        List<String> data = this.cellValueFactory.makeRowData();
        this.model.addRow(Integer.toString(event.getIndex()), data.toArray(new String[data.size()]));
    }

    public void onAppendRow(AppendRowEvent event) {
        List<String> data = this.cellValueFactory.makeRowData();
        this.model.addRow(data.toArray(new String[data.size()]));
    }

    public void onUpdateModel(UpdateModelEvent event) {
        Map updates = event.getUpdates();
        for (Map.Entry e : updates.entrySet()) {
            Coordinate originCoordinate = (Coordinate)e.getKey();
            int originRowIndex = originCoordinate.getRow();
            int originColumnIndex = originCoordinate.getCol();
            List data = (List)e.getValue();
            InterpolationVariable[] vars = this.model.getInterpolationVariablesList();
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                List rowData = (List)data.get(iRow);
                int targetRowIndex = originRowIndex + iRow;
                for (int iCol = 0; iCol < rowData.size(); ++iCol) {
                    int targetColumnIndex = originColumnIndex + iCol;
                    CellValue changedCell = (CellValue)rowData.get(iCol);
                    InterpolationVariable var = vars[targetColumnIndex];
                    TemplateDataColumn col = new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField());
                    String dcv = this.cellValueFactory.convertToModelCell(col, changedCell);
                    List columnData = (List)this.model.getTable().get(var.getVarName());
                    columnData.set(targetRowIndex, dcv);
                }
            }
        }
    }
}

