/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;

public class RuleModelPeerVariableVisitor {
    private final RuleModel model;
    private final String baseVariableName;
    private final List<ValueHolder> peerVariables = new ArrayList<ValueHolder>();

    public RuleModelPeerVariableVisitor(RuleModel model, String baseVariableName) {
        this.model = model;
        this.baseVariableName = baseVariableName;
    }

    public List<ValueHolder> getPeerVariables() {
        this.visit(this.model);
        return this.peerVariables;
    }

    private void visit(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof RuleModel) {
            this.visitRuleModel((RuleModel)o);
        } else if (o instanceof FactPattern) {
            this.visitFactPattern((FactPattern)o);
        } else if (o instanceof CompositeFieldConstraint) {
            this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
        } else if (o instanceof SingleFieldConstraintEBLeftSide) {
            this.visitSingleFieldConstraint((SingleFieldConstraintEBLeftSide)o);
        } else if (o instanceof SingleFieldConstraint) {
            this.visitSingleFieldConstraint((SingleFieldConstraint)o);
        } else if (o instanceof CompositeFactPattern) {
            this.visitCompositeFactPattern((CompositeFactPattern)o);
        } else if (o instanceof FromAccumulateCompositeFactPattern) {
            this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
        } else if (o instanceof FromCollectCompositeFactPattern) {
            this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
        } else if (o instanceof FromCompositeFactPattern) {
            this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
        } else if (o instanceof ActionFieldList) {
            this.visitActionFieldList((ActionFieldList)o);
        }
    }

    private void visitRuleModel(RuleModel rm) {
        for (IPattern iPattern : rm.lhs) {
            this.visit(iPattern);
        }
        for (IPattern iPattern : rm.rhs) {
            this.visit(iPattern);
        }
    }

    private void visitFactPattern(FactPattern fp) {
        if (this.isParentFactPattern(fp)) {
            for (FieldConstraint fc : fp.getFieldConstraints()) {
                this.visit(fc);
            }
        }
    }

    private boolean isParentFactPattern(FactPattern fp) {
        for (FieldConstraint fc : fp.getFieldConstraints()) {
            if (!this.isParentFactPattern(fc)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentFactPattern(FieldConstraint fc) {
        if (fc instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)fc;
            return this.isParentFactPattern(sfc);
        }
        if (fc instanceof CompositeFieldConstraint) {
            CompositeFieldConstraint cfc = (CompositeFieldConstraint)fc;
            return this.isParentFactPattern(cfc);
        }
        return false;
    }

    private boolean isParentFactPattern(SingleFieldConstraint sfc) {
        return sfc.getConstraintValueType() == 7 && sfc.getValue().equals(this.baseVariableName);
    }

    private boolean isParentFactPattern(CompositeFieldConstraint cfc) {
        if (cfc.getCompositeJunctionType().equals("&&")) {
            for (FieldConstraint fc : cfc.getConstraints()) {
                if (!this.isParentFactPattern(fc)) continue;
                return true;
            }
        }
        return false;
    }

    private void visitCompositeFactPattern(CompositeFactPattern cfp) {
        for (IFactPattern p : cfp.getPatterns()) {
            this.visit(p);
        }
    }

    private void visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
        for (FieldConstraint fc : cfc.getConstraints()) {
            this.visit(fc);
        }
    }

    private void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
        if (pattern.getFactPattern() != null) {
            this.visit(pattern.getFactPattern());
        }
    }

    private void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
        if (pattern.getFactPattern() != null) {
            this.visit(pattern.getFactPattern());
        }
    }

    private void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
        if (pattern.getFactPattern() != null) {
            this.visit(pattern.getFactPattern());
        }
    }

    private void visitSingleFieldConstraint(SingleFieldConstraint sfc) {
        if (sfc.getConstraintValueType() == 7) {
            this.peerVariables.add(new ValueHolder(sfc.getFieldName(), sfc.getValue(), ValueHolder.Type.TEMPLATE_KEY));
        } else {
            this.peerVariables.add(new ValueHolder(sfc.getFieldName(), sfc.getValue(), ValueHolder.Type.VALUE));
        }
    }

    private void visitSingleFieldConstraint(SingleFieldConstraintEBLeftSide sfexp) {
        if (sfexp.getConstraintValueType() == 7) {
            this.peerVariables.add(new ValueHolder(sfexp.getFieldName(), sfexp.getValue(), ValueHolder.Type.TEMPLATE_KEY));
        } else {
            this.peerVariables.add(new ValueHolder(sfexp.getFieldName(), sfexp.getValue(), ValueHolder.Type.VALUE));
        }
    }

    private void visitActionFieldList(ActionFieldList afl) {
        boolean addVariables = false;
        ArrayList<ValueHolder> variables = new ArrayList<ValueHolder>();
        for (ActionFieldValue afv : afl.getFieldValues()) {
            ValueHolder vh;
            if (afv.getNature() == 7) {
                if (afv.getValue().equals(this.baseVariableName)) {
                    addVariables = true;
                }
                vh = new ValueHolder(afv.getField(), afv.getValue(), ValueHolder.Type.TEMPLATE_KEY);
                variables.add(vh);
                continue;
            }
            vh = new ValueHolder(afv.getField(), afv.getValue(), ValueHolder.Type.VALUE);
            variables.add(vh);
        }
        if (addVariables) {
            this.peerVariables.addAll(variables);
        }
    }

    public static class ValueHolder {
        private final String fieldName;
        private final String value;
        private final Type type;

        ValueHolder(String fieldName, String value, Type type) {
            this.fieldName = fieldName;
            this.value = value;
            this.type = type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            VALUE,
            TEMPLATE_KEY;

        }
    }
}

