/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.cell.client.Cell;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.client.editor.RuleModelPeerVariableVisitor;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellValueFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataColumn;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellTableDropDownDataValueMapProvider;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.DynamicData;

public class TemplateDropDownManager
implements CellTableDropDownDataValueMapProvider {
    private final TemplateModel model;
    private final AsyncPackageDataModelOracle oracle;
    private final TemplateDataCellValueFactory cellValueFactory;
    private DynamicData data;

    public TemplateDropDownManager(TemplateModel model, AsyncPackageDataModelOracle oracle) {
        if (model == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (oracle == null) {
            throw new IllegalArgumentException("oracle cannot be null");
        }
        this.cellValueFactory = new TemplateDataCellValueFactory(model, oracle);
        this.model = model;
        this.oracle = oracle;
    }

    public void setData(DynamicData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.data = data;
    }

    public Map<String, String> getCurrentValueMap(Cell.Context context) {
        HashMap<String, String> currentValueMap = new HashMap<String, String>();
        int iBaseRowIndex = context.getIndex();
        int iBaseColIndex = context.getColumn();
        InterpolationVariable[] allVariables = this.model.getInterpolationVariablesList();
        InterpolationVariable baseVariable = allVariables[iBaseColIndex];
        String baseVariableName = baseVariable.getVarName();
        RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor((RuleModel)this.model, baseVariableName);
        List<RuleModelPeerVariableVisitor.ValueHolder> peerVariables = peerVariableVisitor.getPeerVariables();
        for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
            switch (valueHolder.getType()) {
                case TEMPLATE_KEY: {
                    int iCol = this.getVariableColumnIndex(valueHolder.getValue());
                    InterpolationVariable variable = allVariables[iCol];
                    String field = variable.getFactField();
                    CellValue cv = this.data.get(iBaseRowIndex).get(iCol);
                    TemplateDataColumn column = this.cellValueFactory.makeModelColumn(variable);
                    String value = this.cellValueFactory.convertToModelCell(column, cv);
                    currentValueMap.put(field, value);
                    break;
                }
                case VALUE: {
                    currentValueMap.put(valueHolder.getFieldName(), valueHolder.getValue());
                }
            }
        }
        return currentValueMap;
    }

    private int getVariableColumnIndex(String variableName) {
        InterpolationVariable[] allVariables = this.model.getInterpolationVariablesList();
        for (int iCol = 0; iCol < allVariables.length; ++iCol) {
            InterpolationVariable var = allVariables[iCol];
            if (!var.getVarName().equals(variableName)) continue;
            return iCol;
        }
        throw new IllegalArgumentException("Variable '" + variableName + "' not found. This suggests an programming error.");
    }

    public Set<Integer> getDependentColumnIndexes(Cell.Context context) {
        int iBaseColIndex = context.getColumn();
        HashSet<Integer> dependentColumnIndexes = new HashSet<Integer>();
        InterpolationVariable[] allVariables = this.model.getInterpolationVariablesList();
        InterpolationVariable baseVariable = allVariables[iBaseColIndex];
        String baseVariableName = baseVariable.getVarName();
        RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor((RuleModel)this.model, baseVariableName);
        List<RuleModelPeerVariableVisitor.ValueHolder> peerVariables = peerVariableVisitor.getPeerVariables();
        for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
            switch (valueHolder.getType()) {
                case TEMPLATE_KEY: {
                    int iCol = this.getVariableColumnIndex(valueHolder.getValue());
                    InterpolationVariable variable = allVariables[iCol];
                    String field = variable.getFactField();
                    if (!this.oracle.isDependentEnum(baseVariable.getFactType(), baseVariable.getFactField(), field)) break;
                    dependentColumnIndexes.add(iCol);
                }
            }
        }
        return dependentColumnIndexes;
    }
}

