/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataColumn;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDropDownManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.AbstractProxyPopupDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericBigDecimalDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericBigIntegerDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericByteDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericDoubleDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericFloatDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericIntegerDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericLongDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupNumericShortDropDownEditCell;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.cells.ProxyPopupTextDropDownEditCell;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@WithClassesToStub(value={DateTimeFormat.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class TemplateDataCellFactoryTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private TemplateDropDownManager dropDownManager;
    private boolean isReadOnly = false;
    @Mock
    private EventBus eventBus;
    @Mock
    private TemplateDataColumn column;
    @Captor
    private ArgumentCaptor<AbstractProxyPopupDropDownEditCell> puddCaptor;
    private TemplateDataCellFactory testedFactory;

    @Before
    public void setUp() throws Exception {
        this.testedFactory = (TemplateDataCellFactory)Mockito.spy((Object)new TemplateDataCellFactory(this.oracle, this.dropDownManager, this.isReadOnly, this.eventBus));
    }

    @Test
    public void testGetCell() throws Exception {
        String factType = "org.kiegroup.Car";
        String factField = "color";
        String dataType = DataType.DataTypes.STRING.name();
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"color").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)dataType).when((Object)this.column)).getDataType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"==").when((Object)this.column)).getOperator();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeSelectionEnumCell("org.kiegroup.Car", "color", "==", dataType);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).makeTextCellWrapper();
    }

    @Test
    public void testGetCellWhenEnumPresent() throws Exception {
        String factType = "org.kiegroup.Car";
        String factField = "color";
        String dataType = DataType.DataTypes.STRING.name();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)true).when((Object)this.oracle)).hasEnums("org.kiegroup.Car", "color");
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"color").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)dataType).when((Object)this.column)).getDataType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"==").when((Object)this.column)).getOperator();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).makeSelectionEnumCell("org.kiegroup.Car", "color", "==", dataType);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeTextCellWrapper();
    }

    @Test
    public void testDoNotGetCellWhenEnumPresentIfDataTypeIsDefault() throws Exception {
        String factType = "org.kiegroup.Car";
        String factField = "color";
        String dataType = "DEFAULT_TYPE";
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)true).when((Object)this.oracle)).hasEnums("org.kiegroup.Car", "color");
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"color").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)"DEFAULT_TYPE").when((Object)this.column)).getDataType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"==").when((Object)this.column)).getOperator();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeSelectionEnumCell(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).makeTextCellWrapper();
    }

    @Test
    public void testGetCellForInteger() {
        String factType = "org.kiegroup.Car";
        String factField = "price";
        String dataType = "Integer";
        String operator = ">";
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"price").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)"Integer").when((Object)this.column)).getDataType();
        ((TemplateDataColumn)Mockito.doReturn((Object)">").when((Object)this.column)).getOperator();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeSelectionEnumCell("org.kiegroup.Car", "price", ">", "Integer");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeTextCellWrapper();
    }

    @Test
    public void testGetCellForListOperator() {
        String factType = "org.kiegroup.Car";
        String factField = "price";
        String dataType = "Integer";
        String operator = "in";
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"price").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)"Integer").when((Object)this.column)).getDataType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"in").when((Object)this.column)).getOperator();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeSelectionEnumCell("org.kiegroup.Car", "price", "in", "Integer");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).makeTextCellWrapper();
    }

    @Test
    public void testEnumHasPriorityOverListOperator() throws Exception {
        this.testEnumAndOperator("String", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorNumeric() throws Exception {
        this.testEnumAndOperator("Numeric", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorBigDecimal() throws Exception {
        this.testEnumAndOperator("BigDecimal", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorBigInteger() throws Exception {
        this.testEnumAndOperator("BigInteger", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorByte() throws Exception {
        this.testEnumAndOperator("Byte", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorDouble() throws Exception {
        this.testEnumAndOperator("Double", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorFloat() throws Exception {
        this.testEnumAndOperator("Float", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorInteger() throws Exception {
        this.testEnumAndOperator("Integer", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorLong() throws Exception {
        this.testEnumAndOperator("Long", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityOverListOperatorShort() throws Exception {
        this.testEnumAndOperator("Short", "in");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupTextDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorNumeric() throws Exception {
        this.testEnumAndOperator("Numeric", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericBigDecimalDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorBigDecimal() throws Exception {
        this.testEnumAndOperator("BigDecimal", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericBigDecimalDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorBigInteger() throws Exception {
        this.testEnumAndOperator("BigInteger", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericBigIntegerDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorByte() throws Exception {
        this.testEnumAndOperator("Byte", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericByteDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorDouble() throws Exception {
        this.testEnumAndOperator("Double", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericDoubleDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorFloat() throws Exception {
        this.testEnumAndOperator("Float", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericFloatDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorInteger() throws Exception {
        this.testEnumAndOperator("Integer", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericIntegerDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorLong() throws Exception {
        this.testEnumAndOperator("Long", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericLongDropDownEditCell));
    }

    @Test
    public void testEnumHasPriorityButSimpleOperatorShort() throws Exception {
        this.testEnumAndOperator("Short", "==");
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).decoratedGridCellValueAdaptor((AbstractProxyPopupDropDownEditCell)this.puddCaptor.capture());
        Assert.assertTrue((boolean)(this.puddCaptor.getValue() instanceof ProxyPopupNumericShortDropDownEditCell));
    }

    @Test(expected=IllegalStateException.class)
    public void testIllegalNumericType() {
        String factType = "org.kiegroup.Car";
        String factField = "carAttribute";
        String dataType = "Date";
        String operator = "in";
        this.testedFactory.makeNumericSelectionEnumCell("org.kiegroup.Car", "carAttribute", "Date", "in");
    }

    private void testEnumAndOperator(String dataType, String operator) throws Exception {
        String factType = "org.kiegroup.Car";
        String factField = "carAttribute";
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)true).when((Object)this.oracle)).hasEnums("org.kiegroup.Car", "carAttribute");
        ((TemplateDataColumn)Mockito.doReturn((Object)"org.kiegroup.Car").when((Object)this.column)).getFactType();
        ((TemplateDataColumn)Mockito.doReturn((Object)"carAttribute").when((Object)this.column)).getFactField();
        ((TemplateDataColumn)Mockito.doReturn((Object)dataType).when((Object)this.column)).getDataType();
        ((TemplateDataColumn)Mockito.doReturn((Object)operator).when((Object)this.column)).getOperator();
        this.testedFactory.getCell(this.column);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory)).makeSelectionEnumCell("org.kiegroup.Car", "carAttribute", operator, dataType);
        ((TemplateDataCellFactory)Mockito.verify((Object)this.testedFactory, (VerificationMode)Mockito.never())).makeTextCellWrapper();
    }
}

