/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellValueFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataTableWidget;
import org.drools.workbench.screens.guided.template.client.editor.VerticalDecoratedTemplateDataGridWidget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.AbstractCellFactory;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={AbstractCellFactory.class, VerticalDecoratedTemplateDataGridWidget.class, DateTimeFormat.class})
public class TemplateDataTableWidgetTest {
    @Mock
    private EventBus eventBusMock;
    @Mock
    private AsyncPackageDataModelOracle oracleMock;
    @Mock
    private TemplateModel modelMock;
    @Mock
    private TemplateDataCellValueFactory cellValueFactoryMock;
    private TemplateDataTableWidget dataTableWidget;

    @Before
    public void setUp() throws Exception {
        this.dataTableWidget = new TemplateDataTableWidget(this.modelMock, this.oracleMock, false, this.eventBusMock);
        this.dataTableWidget.cellValueFactory = this.cellValueFactoryMock;
    }

    @Test
    public void testOnInsertRow() {
        int index = 123;
        List<String> rowData = Collections.singletonList("abc");
        InsertRowEvent insertRowEvent = (InsertRowEvent)Mockito.mock(InsertRowEvent.class);
        Mockito.when((Object)insertRowEvent.getIndex()).thenReturn((Object)123);
        Mockito.when((Object)this.cellValueFactoryMock.makeRowData()).thenReturn(rowData);
        this.dataTableWidget.onInsertRow(insertRowEvent);
        ((TemplateModel)Mockito.verify((Object)this.modelMock)).addRow(Matchers.eq((int)123), (String[])Matchers.eq((Object)rowData.toArray(new String[1])));
    }
}

