/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.client.editor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataCellValueFactory;
import org.drools.workbench.screens.guided.template.client.editor.TemplateDataColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.soup.project.datamodel.oracle.DateConverter;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.CellValue;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TemplateDataCellValueFactoryTest {
    private String datatype;
    private String operator;
    private Comparable cellValue;
    private Object result;
    private TemplateDataCellValueFactory templateDataCellValueFactory;

    public TemplateDataCellValueFactoryTest(String datatype, String operator, Comparable cellValue, String result) {
        this.datatype = datatype;
        this.operator = operator;
        this.cellValue = cellValue;
        this.result = result;
    }

    @Before
    public void setUp() throws Exception {
        this.templateDataCellValueFactory = new TemplateDataCellValueFactory((TemplateModel)Mockito.mock(TemplateModel.class), (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class));
        TemplateDataCellValueFactory.DATE_CONVERTOR = new DateConverter(){

            public String format(Date date) {
                return "1.1.1111";
            }

            public Date parse(String text) {
                return null;
            }
        };
    }

    @Test
    public void testConvertToModelCell() {
        String actualResult = this.templateDataCellValueFactory.convertToModelCell(new TemplateDataColumn("var", this.datatype, "Person", "age", this.operator), new CellValue(this.cellValue));
        Assert.assertEquals((Object)this.result, (Object)actualResult);
    }

    @Parameterized.Parameters
    public static Collection testParameters() {
        return Arrays.asList({"String", "in", null, null}, {"String", "==", null, null}, {"String", "==", "hi", "hi"}, {"Boolean", "in", null, null}, {"Boolean", "==", null, null}, {"Boolean", "==", true, "true"}, {"Date", "in", null, null}, {"Date", "==", null, null}, {"Date", "==", new Date(), "1.1.1111"}, {"Numeric", "in", null, null}, {"Numeric", "==", null, null}, {"Numeric", "==", new BigDecimal(2.0), "2"}, {"BigDecimal", "in", null, null}, {"BigDecimal", "==", null, null}, {"BigDecimal", "==", new BigDecimal(4.0), "4"}, {"BigInteger", "in", null, null}, {"BigInteger", "==", null, null}, {"BigInteger", "==", new BigInteger("5"), "5"}, {"Byte", "in", null, null}, {"Byte", "==", null, null}, {"Byte", "==", new Byte("6"), "6"}, {"Double", "in", null, null}, {"Double", "==", null, null}, {"Double", "==", 7.0, "7.0"}, {"Float", "in", null, null}, {"Float", "==", null, null}, {"Float", "==", Float.valueOf(8.0f), "8.0"}, {"Integer", "in", null, null}, {"Integer", "==", null, null}, {"Integer", "==", 11, "11"}, {"Long", "in", null, null}, {"Long", "==", null, null}, {"Long", "==", 12L, "12"}, {"Short", "in", null, null}, {"Short", "==", null, null}, {"Short", "==", new Short("0"), "0"});
    }
}

